class Premise:
    """前提id"""

    """
    =========================
    角色身份类前提
    =========================
    """
    TARGET_NO_PLAYER = "target_no_player"
    """ 交互对象不是玩家 """
    IS_STUDENT = "is_student"
    """ 是学生 """
    IS_TEACHER = "is_teacher"
    """ 是老师 """
    TARGET_IS_PLAYER = "target_is_player"
    """ 目标是玩家角色 """
    IS_PLAYER = "is_player"
    """ 是玩家角色 """
    NO_PLAYER = "no_player"
    """ 不是玩家角色 """
    TARGET_IS_STUDENT = "target_is_student"
    """ 交互对象是学生 """
    IS_PRIMARY_SCHOOL_STUDENTS = "is_primary_school_students"
    """ 角色是小学生 """
    IS_PLAYER_TARGET = "is_player_target"
    """ 是玩家的交互对象 """
    IS_JOINED_CLUB = "is_joined_club"
    """ 已经加入社团 """
    NOT_JOINED_CLUB = "not_joined_club"
    """ 没有加入社团 """

    """
    =========================
    角色性别类前提
    =========================
    """
    TARGET_IS_FUTA_OR_WOMAN = "target_is_futa_or_woman"
    """ 目标是扶她或女性 """
    TARGET_IS_FUTA_OR_MAN = "target_is_futa_or_man"
    """ 目标是扶她或男性 """
    IS_MAN = "is_man"
    """ 角色是男性 """
    IS_NOT_MAN = "is_not_man"
    """ 角色不是男性 """
    IS_WOMAN = "is_woman"
    """ 角色是女性 """
    IS_FUTA = "is_futa"
    """ 角色是扶她 """
    IS_ASEXUAL = "is_asexual"
    """ 角色是无性 """
    IS_FUTA_OR_MAN = "is_futa_or_man"
    """ 角色是扶她或男性 """
    TARGET_SAME_SEX = "target_same_sex"
    """ 目标与自身性别相同 """
    TARGET_DIFFERENT_SEX = "target_different_sex"
    """ 交互对象与自身性别不同 """
    TARGET_IS_WOMAN = "target_is_woman"
    """ 交互对象是女性 """
    TARGET_IS_MAN = "target_is_man"
    """ 交互对象是男性 """
    IS_MAN_OR_WOMAN = "is_man_or_woman"
    """ 角色是男性或女性 """
    IS_NOT_ASEXUAL = "is_not_asexual"
    """ 角色不是无性 """
    IS_FUTA_OR_WOMAN = "is_futa_or_woman"
    """ 角色是扶她或女性 """

    """
    =========================
    角色性格类前提
    =========================
    """
    IS_LIVELY = "is_lively"
    """ 是一个活跃的人 """
    IS_LOW_KEY = "is_low_key"
    """ 是一个低调的人 """
    IS_GREGARIOUS = "is_gregarious"
    """ 是一个合群的人 """
    IS_SOLITARY = "is_solitary"
    """ 是一个孤僻的人 """
    IS_OPTIMISTIC = "is_optimistic"
    """ 是一个乐观的人 """
    IS_PESSIMISM = "is_pessimism"
    """ 是一个悲观的人 """
    IS_KEEP_PROMISES = "is_keep_promises"
    """ 是一个守信的人 """
    IS_DECEITFUL = "is_deceitful"
    """ 是一个狡诈的人 """
    IS_SELFLESS = "is_selfless"
    """ 是一个无私的人 """
    IS_SELFISH = "is_selfish"
    """ 是一个自私的人 """
    IS_HEAVY_FEELING = "is_heavy_feeling"
    """ 是一个重情的人 """
    IS_UNGRATEFUL = "is_ungrateful"
    """ 是一个薄情的人 """
    IS_RIGOROUS = "is_rigorous"
    """ 是一个严谨的人 """
    IS_RELAX = "is_relax"
    """ 是一个松散的人 """
    IS_AUTONOMY = "is_autonomy"
    """ 是一个自律的人 """
    IS_INDULGE = "is_indulge"
    """ 是一个放纵的人 """
    IS_STEADY = "is_steady"
    """ 是一个沉稳的人 """
    IS_CHILDISH = "is_childish"
    """ 是一个稚拙的人 """
    IS_RESOLUTION = "is_resolution"
    """ 是一个决断的人 """
    IS_HESITATE = "is_hesitate"
    """ 是一个犹豫的人 """
    IS_TENACITY = "is_tenacity"
    """ 是一个坚韧的人 """
    IS_FRAGILE = "is_fragile"
    """ 是一个脆弱的人 """
    IS_ASTUTE = "is_astute"
    """ 是一个机敏的人 """
    IS_SLOW = "is_slow"
    """ 是一个迟钝的人 """
    IS_TOLERANCE = "is_tolerance"
    """ 是一个耐性的人 """
    IS_IMPETUOUS = "is_impetuous"
    """ 是一个浮躁的人 """
    IS_STARAIGHTFORWARD = "is_staraightforward"
    """ 是一个爽直的人 """
    IS_INSIDIOUS = "is_insidious"
    """ 是一个阴险的人 """
    IS_TOLERANT = "is_tolerant"
    """ 是一个宽和的人 """
    IS_NARROW = "is_narrow"
    """ 是一个狭隘的人 """
    IS_ENTHUSIASM = "is_enthusiasm"
    """ 是一个热情的人 """
    IS_APATHY = "is_apathy"
    """ 是一个冷漠的人 """
    IS_SELF_CONFIDENCE = "is_self_confidence"
    """ 是一个自信的人 """
    IS_INFERIORITY = "is_inferiority"
    """ 是一个自卑的人 """
    IS_INFFERENT = "is_infferent"
    """ 是一个淡泊的人 """
    IS_KEEN = "is_keen"
    """ 是一个热衷的人 """
    IS_HUMOR_MAN = "is_humor_man"
    """ 是一个幽默的人 """

    """
    =========================
    交互对象性格类前提
    =========================
    """
    TARGET_IS_LIVELY = "target_is_lively"
    """ 交互对象是一个活跃的人 """
    TARGET_IS_LOW_KEY = "target_is_low_key"
    """ 交互对象是一个低调的人 """
    TARGET_IS_GREGARIOUS = "target_is_gregarious"
    """ 交互对象是一个合群的人 """
    TARGET_IS_SOLITARY = "target_is_solitary"
    """ 交互对象是一个孤僻的人 """
    TARGET_IS_OPTIMISTIC = "target_is_optimistic"
    """ 交互对象是一个乐观的人 """
    TARGET_IS_PESSIMISM = "target_is_pessimism"
    """ 交互对象是一个悲观的人 """
    TARGET_IS_KEEP_PROMISES = "target_is_keep_promises"
    """ 交互对象是一个守信的人 """
    TARGET_IS_DECEITFUL = "target_is_deceitful"
    """ 交互对象是一个狡诈的人 """
    TARGET_IS_SELFLESS = "target_is_selfless"
    """ 交互对象是一个无私的人 """
    TARGET_IS_SELFISH = "target_is_selfish"
    """ 交互对象是一个自私的人 """
    TARGET_IS_HEAVY_FEELING = "target_is_heavy_feeling"
    """ 交互对象是一个重情的人 """
    TARGET_IS_UNGRATEFUL = "target_is_ungrateful"
    """ 交互对象是一个薄情的人 """
    TARGET_IS_RIGOROUS = "target_is_rigorous"
    """ 交互对象是一个严谨的人 """
    TARGET_IS_RELAX = "target_is_relax"
    """ 交互对象是一个松散的人 """
    TARGET_IS_AUTONOMY = "target_is_autonomy"
    """ 交互对象是一个自律的人 """
    TARGET_IS_INDULGE = "target_is_indulge"
    """ 交互对象是一个放纵的人 """
    TARGET_IS_STEADY = "target_is_steady"
    """ 交互对象是一个沉稳的人 """
    TARGET_IS_CHILDISH = "target_is_childish"
    """ 交互对象是一个稚拙的人 """
    TARGET_IS_RESOLUTION = "target_is_resolution"
    """ 交互对象是一个决断的人 """
    TARGET_IS_HESITATE = "target_is_hesitate"
    """ 交互对象是一个犹豫的人 """
    TARGET_IS_TENACITY = "target_is_tenacity"
    """ 交互对象是一个坚韧的人 """
    TARGET_IS_FRAGILE = "target_is_fragile"
    """ 交互对象是一个脆弱的人 """
    TARGET_IS_ASTUTE = "target_is_astute"
    """ 交互对象是一个机敏的人 """
    TARGET_IS_SLOW = "target_is_slow"
    """ 交互对象是一个迟钝的人 """
    TARGET_IS_TOLERANCE = "target_is_tolerance"
    """ 交互对象是一个耐性的人 """
    TARGET_IS_IMPETUOUS = "target_is_impetuous"
    """ 交互对象是一个浮躁的人 """
    TARGET_IS_STARAIGHTFORWARD = "target_is_staraightforward"
    """ 交互对象是一个爽直的人 """
    TARGET_IS_INSIDIOUS = "target_is_insidious"
    """ 交互对象是一个阴险的人 """
    TARGET_IS_TOLERANT = "target_is_tolerant"
    """ 交互对象是一个宽和的人 """
    TARGET_IS_NARROW = "target_is_narrow"
    """ 交互对象是一个狭隘的人 """
    TARGET_IS_ENTHUSIASM = "target_is_enthusiasm"
    """ 交互对象是一个热情的人 """
    TARGET_IS_APATHY = "target_is_apathy"
    """ 交互对象是一个冷漠的人 """
    TARGET_IS_SELF_CONFIDENCE = "target_is_self_confidence"
    """ 交互对象是一个自信的人 """
    TARGET_IS_INFERIORITY = "target_is_inferiority"
    """ 交互对象是一个自卑的人 """
    TARGET_IS_INFFERENT = "target_is_infferent"
    """ 交互对象是一个淡泊的人 """
    TARGET_IS_KEEN = "target_is_humor_man"
    """ 交互对象是一个热衷的人 """

    """
    =========================
    场景状态类前提
    =========================
    """
    IN_DOOR = "in_door"
    """ 处于室内 """
    OUT_DOOR = "out_door"
    """ 处于室外 """
    IN_SQUARE = "in_square"
    """ 处于操场 """
    NOT_IN_SQUARE = "not_in_square"
    """ 不处于操场中 """
    IN_CAFETERIA = "in_cafeteria"
    """ 处于取餐区 """
    IN_RESTAURANT = "in_restaurant"
    """ 处于就餐区 """
    IN_SWIMMING_POOL = "in_swimming_pool"
    """ 在游泳池中 """
    IN_CLASSROOM = "in_classroom"
    """ 在教室中 """
    IN_SHOP = "in_shop"
    """ 在商店中 """
    IN_TOILET = "in_toilet"
    """ 在洗手间中 """
    NOT_IN_TOILET = "not_in_toilet"
    """ 不在洗手间中 """
    IN_PLAYER_SCENE = "in_player_scene"
    """ 与玩家处于相同场景 """
    SCENE_HAVE_OTHER_CHARACTER = "scene_have_other_character"
    """ 场景中有自己外的其他角色 """
    IN_DORMITORY = "in_dormitory"
    """ 在宿舍中 """
    NOT_IN_DORMITORY = "not_in_dormitory"
    """ 不在宿舍中 """
    IN_TARGET_DORMITORY = "in_target_dormitory"
    """ 处于交互对象的宿舍中 """
    IN_MUSIC_CLASSROOM = "in_music_classroom"
    """ 处于音乐活动室 """
    NOT_IN_MUSIC_CLASSROOM = "not_in_music_classroom"
    """ 角色未处于音乐活动室 """
    IN_COMPUTER_ROOM_SCENE = "in_computer_room_scene"
    """ 处于计算机实践室 """
    SCENE_NO_HAVE_OTHER_CHARACTER = "scene_no_have_other_character"
    """ 场景中没有有自己外的其他角色 """
    SCENE_CHARACTER_ONLY_PLAYER_AND_ONE = "scene_character_only_player_and_one"
    """ 场景中只有包括玩家在内的两个角色 """
    BEYOND_FRIENDSHIP_TARGET_IN_SCENE = "beyond_friendship_target_in_scene"
    """ 对场景中某个角色抱有超越友谊的想法 """
    IN_FOUNTAIN = "in_fountain"
    """ 在喷泉场景 """
    IN_LIBRARY = "in_library"
    """ 在图书馆中 """
    NOT_IN_LIBRARY = "not_in_library"
    """ 不在图书馆中 """
    HAVE_OTHER_TARGET_IN_SCENE = "have_other_target_in_scene"
    """ 场景中有自己和交互对象以外的其他人 """
    NO_HAVE_OTHER_TARGET_IN_SCENE = "no_have_other_target_in_scene"
    """ 场景中没有自己和交互对象以外的其他人 """
    HAVE_LIKE_TARGET_IN_SCENE = "have_like_target_in_scene"
    """ 场景中有喜欢的人 """
    HAVE_NO_FIRST_KISS_LIKE_TARGET_IN_SCENE = "have_no_first_kiss_like_target_in_scene"
    """ 有自己喜欢的还是初吻的人在场景中 """
    HAVE_DISLIKE_TARGET_IN_SCENE = "have_dislike_target_in_scene"
    """ 场景中有自己讨厌的人 """
    NOT_HAS_DISLIKE_TARGET_IN_SCENE = "not_has_dislike_target_in_scene"
    """ 场景中没有自己讨厌的人 """
    NO_IN_CLASSROOM = "no_in_classroom"
    """ 不在教室中 """
    TEACHER_NO_IN_CLASSROOM = "teacher_no_in_classroom"
    """ 角色所属班级的老师不在教室中 """
    TEACHER_IN_CLASSROOM = "teacher_in_classroom"
    """ 角色所属班级的老师在教室中 """
    IS_BEYOND_FRIENDSHIP_TARGET_IN_SCENE = "is_beyond_friendship_target_in_scene"
    """ 场景中有角色对自己抱有超越友谊的想法 """
    HAVE_STUDENTS_IN_CLASSROOM = "have_students_in_classroom"
    """ 有所教班级的学生在教室中 """
    IN_ROOFTOP_SCENE = "in_rooftop_scene"
    """ 处于天台场景 """
    IN_GROVE = "in_grove"
    """ 处于小树林场景 """
    NO_IN_GROVE = "no_in_grove"
    """ 未处于小树林场景 """
    NAKED_CHARACTER_IN_SCENE = "naked_character_in_scene"
    """ 场景中有人一丝不挂 """
    IN_ITEM_SHOP = "in_item_shop"
    """ 不在超市中 """
    NO_IN_ITEM_SHOP = "no_in_item_shop"
    """ 在超市中 """
    IN_STUDENT_UNION_OFFICE = "in_student_union_office"
    """ 在学生会办公室中 """
    NO_IN_CAFETERIA = "no_in_cafeteria"
    """ 未处于取餐区 """
    NO_IN_RESTAURANT = "no_in_restaurant"
    """ 未处于就餐区 """
    HAVE_PLAY_PIANO_IN_SCENE = "have_play_piano_in_scene"
    """ 场景中有人在弹钢琴 """
    HAVE_SINGING_IN_SCENE = "have_singing_in_scene"
    """ 场景中有人在唱歌 """
    PLAYER_NOT_IN_TARGET_SCENE = "player_not_in_target_scene"
    """ 玩家不在角色的目标场景中 """
    PLAYER_IN_TARGET_SCENE = "player_in_target_scene"
    """ 玩家在角色的目标场景中 """
    HAS_NO_CHARACTER_SCENE = "has_no_character_scene"
    """ 存在空无一人的场景 """
    NOT_HAS_LIKE_CHARACTER_IN_SCENE = "not_has_like_character_in_scene"
    """ 场景中没有自己喜欢的人 """
    IN_CLUB_ACTIVITY_SCENE = "in_club_activity_scene"
    """ 处于社团活动场景 """
    NOT_IN_CLUB_ACTIVITY_SCENE = "not_in_club_activity_scene"
    """ 未处于社团活动场景 """

    """
    =========================
    时间状态类前提
    =========================
    """
    IN_BREAKFAST_TIME = "in_breakfast_time"
    """ 处于早餐时间段 """
    IN_LUNCH_TIME = "in_lunch_time"
    """ 处于午餐时间段 """
    IN_DINNER_TIME = "in_dinner_time"
    """ 处于晚餐时间段 """
    IN_SLEEP_TIME = "in_sleep_time"
    """ 处于睡觉时间 """
    IN_SIESTA_TIME = "in_siesta_time"
    """ 处于午休时间 """
    NO_IN_SLEEP_TIME = "no_in_sleep_time"
    """ 不处于睡觉时间 """
    ATTEND_CLASS_TODAY = "attend_class_today"
    """ 今日需要上课 """
    APPROACHING_CLASS_TIME = "approaching_class_time"
    """ 临近上课时间 """
    IN_CLASS_TIME = "in_class_time"
    """ 处于上课时间 """
    NOT_IN_CLASS_TIME = "not_in_class_time"
    """ 不处于上课时间 """
    TONIGHT_IS_FULL_MOON = "tonight_is_full_moon"
    """ 今夜是满月 """
    TONIGHT_IS_KAIMU_MOON = "tonight_is_kaimu_moon"
    """ 今夜是晦月 """
    TONIGHT_IS_SHAKUGETSU_MOON = "tonight_is_shakugetsu_moon"
    """ 今夜是朔月 """
    TONIGHT_IS_SHINGETSU_MOON = "tonight_is_shingetsu_moon"
    """ 今夜是新月 """
    TONIGHT_IS_KISHAKUGETSU_MOON = "tonight_is_kishakugetsu_moon"
    """ 今夜是既朔月 """
    TONIGHT_IS_MIKAZUKI_MOON = "tonight_is_mikazuki_moon"
    """ 今夜是三日月 """
    TONIGHT_IS_GABI_TSUKI_MOON = "tonight_is_gabi_tsuki_moon"
    """ 今夜是蛾眉月 """
    TONIGHT_IS_YUZUKI_MOON = "tonight_is_yuzuki_moon"
    """ 今夜是夕月 """
    TONIGHT_IS_JOGENGETSU_MOON = "tonight_is_jogengetsu_moon"
    """ 今夜是上弦月 """
    TONIGHT_IS_KOKONOYOTSUKI_MOON = "tonight_is_kokonoyotsuki_moon"
    """ 今夜是九夜月 """
    TONIGHT_IS_YOI_TSUKI_MOON = "tonight_is_yoi_tsuki_moon"
    """ 今夜是宵月 """
    TONIGHT_IS_JUSAN_NICHI_TSUKI_MOON = "tonight_is_jusan_nichi_tsuki_moon"
    """ 今夜是十三日月 """
    TONIGHT_IS_SHOBOGETSU_MOON = "tonight_is_shobogetsu_moon"
    """ 今夜是小望月 """
    TONIGHT_IS_KIBOGETSU_MOON = "tonight_is_kibogetsu_moon"
    """ 今夜是既望月 """
    TONIGHT_IS_TATIMACHI_TSUKI_MOON = "tonight_is_tatimachi_tsuki_moon"
    """ 今夜是立待月 """
    TONIGHT_IS_IMACHI_TSUKI_MOON = "tonight_is_imachi_tsuki_moon"
    """ 今夜是居待月 """
    TONIGHT_IS_NEMACHI_TSUKI_MOON = "tonight_is_nemachi_tsuki_moon"
    """ 今夜是寝待月 """
    TONIGHT_IS_KOMACHI_TSUKI_MOON = "tonight_is_komachi_tsuki_moon"
    """ 今夜是更待月 """
    TONIGHT_IS_KAISUKI_MOON = "tonight_is_kaisuki_moon"
    """ 今夜是亏凸月 """
    TONIGHT_IS_YUMIBARIZUKI_MOON = "tonight_is_yumibarizuki_moon"
    """ 今夜是弓张月 """
    TONIGHT_IS_ARIAKE_MOON = "tonight_is_ariake_moon"
    """ 今夜是有明月 """
    TONIGHT_IS_GABI_ZANGETSU_MOON = "tonight_is_gabi_zangetsu_moon"
    """ 今夜是蛾眉残月 """
    TONIGHT_IS_ZANGETSU_MOON = "tonight_is_zangetsu_moon"
    """ 今夜是残月 """
    TONIGHT_IS_AKATSUKI_MOON = "tonight_is_akatsuki_moon"
    """ 今夜是晓月 """
    IS_SPRING = "is_spring"
    """ 现在是春天 """
    IS_SUMMER = "is_summer"
    """ 现在是夏天 """
    IS_FALL = "is_fall"
    """ 现在是秋天 """
    IS_WINTER = "is_winter"
    """ 现在是冬天 """
    IS_NIGHT = "is_night"
    """ 处于夜晚 """
    IS_NOT_NIGHT = "is_not_night"
    """ 不处于夜晚 """
    IS_CLUB_ACTIVITY_TIME = "is_club_activity_time"
    """ 处于社团活动时间 """

    """
    =========================
    角色人文技能类前提
    =========================
    """
    ETHIC_IS_HEIGHT = "ethic_is_height"
    """ 角色伦理水平高 """
    ETHIC_IS_LOW = "ethic_is_low"
    """ 角色伦理水平低 """
    MORALITY_IS_HEIGHT = "morality_is_height"
    """ 角色道德水平高 """
    MORALITY_IS_LOW = "morality_is_low"
    """ 角色道德水平低 """
    LITERATURE_IS_HEIGHT = "literature_is_height"
    """ 角色文学水平高 """
    LITERATURE_IS_LOW = "literature_is_low"
    """ 角色文学水平低 """
    POETRY_IS_HEIGHT = "poetry_is_height"
    """ 角色诗歌水平高 """
    POETRY_IS_LOW = "poetry_is_low"
    """ 角色诗歌水平低 """
    HISTORY_IS_HEIGHT = "history_is_height"
    """ 角色历史水平高 """
    HISTORY_IS_LOW = "history_is_low"
    """ 角色历史水平低 """
    ART_IS_HEIGHT = "art_is_height"
    """ 角色艺术水平高 """
    ART_IS_LOW = "art_is_low"
    """ 角色艺术水平低 """
    MUSIC_THEORY_IS_HEIGHT = "music_theory_is_height"
    """ 角色乐理水平高 """
    MUSIC_THEORY_IS_LOW = "music_theory_is_low"
    """ 角色乐理水平低 """
    RELIGION_IS_HEIGHT = "religion_is_height"
    """ 角色宗教水平高 """
    RELIGION_IS_LOW = "religion_is_low"
    """ 角色宗教水平低 """
    FAITH_IS_HEIGHT = "faith_is_height"
    """ 角色信仰水平高 """
    FAITH_IS_LOW = "faith_is_low"
    """ 角色信仰水平低 """

    """
    =========================
    角色技巧技能类前提
    =========================
    """
    SEXUAL_SKILLS_IS_HEIGHT = "sexual_skills_is_height"
    """ 角色性爱水平高 """
    SEXUAL_SKILLS_IS_LOW = "sexual_skills_is_low"
    """ 角色性爱水平低 """
    COMPUTER_SKILLS_IS_HEIGHT = "computer_skills_is_height"
    """ 角色计算机水平高 """
    COMPUTER_SKILLS_IS_LOW = "computer_skills_is_low"
    """ 角色计算机水平低 """
    PERFORMANCE_SKILLS_IS_HEIGHT = "performance_skills_is_height"
    """ 角色表演水平高 """
    PERFORMANCE_SKILLS_IS_LOW = "perform_skills_is_low"
    """ 角色表演水平低 """
    ELOQUENCE_SKILLS_IS_HEIGHT = "eloquence_skills_is_height"
    """ 角色口才水平高 """
    ELOQUENCE_SKILLS_IS_LOW = "eloquence_skills_is_low"
    """ 角色口才水平低 """
    PAINTING_SKILLS_IS_HEIGHT = "painting_skills_is_height"
    """ 角色绘画水平高 """
    PAINTING_SKILLS_IS_LOW = "painting_skills_is_low"
    """ 角色绘画水平低 """
    SHOOT_SKILLS_IS_HEIGHT = "shoot_skills_is_height"
    """ 角色拍摄水平高 """
    SHOOT_SKILLS_IS_LOW = "shoot_skills_is_low"
    """ 角色拍摄水平低 """
    SINGING_SKILLS_IS_HEIGHT = "singing_skills_is_height"
    """ 角色演唱水平高 """
    SINGING_SKILLS_IS_LOW = "singing_skills_is_low"
    """ 角色演唱水平低 """
    WRITE_MUSIC_SKILLS_IS_HEIGHT = "write_music_skills_is_height"
    """ 角色作曲水平高 """
    WRITE_MUSIC_SKILLS_IS_LOW = "write_music_skills_is_low"
    """ 角色作曲水平低 """
    COOKING_SKILLS_IS_HEIGHT = "cooking_skills_is_height"
    """ 角色厨艺水平高 """
    COOKING_SKILLS_IS_LOW = "cooking_skills_is_low"
    """ 角色厨艺水平低 """
    DANCE_SKILLS_IS_HEIGHT = "dance_skills_is_height"
    """ 角色舞蹈水平高 """
    DANCE_SKILLS_IS_LOW = "dance_skills_is_low"
    """ 角色舞蹈水平低 """
    TAILOR_SKILLS_IS_HEIGHT = "tailor_skills_is_height"
    """ 角色裁缝水平高 """
    TAILOR_SKILLS_IS_LOW = "tailor_skills_is_low"
    """ 角色裁缝水平低 """
    TACTICS_SKILLS_IS_HEIGHT = "tactics_skills_is_height"
    """ 角色战术水平高 """
    TACTICS_SKILLS_IS_LOW = "tactics_skills_is_low"
    """ 角色战术水平低 """
    SWIMMING_SKILLS_IS_HEIGHT = "swimming_skills_is_height"
    """ 角色游泳水平高 """
    SWIMMING_SKILLS_IS_LOW = "swimming_skills_is_low"
    """ 角色游泳水平低 """
    MANUFACTURE_SKILLS_IS_HEIGHT = "manufacture_skills_is_height"
    """ 角色制造水平高 """
    MANUFACTURE_SKILLS_IS_LOW = "manufacture_skills_is_low"
    """ 角色制造水平低 """
    FIRST_AID_SKILLS_IS_HEIGHT = "first_aid_skills_is_height"
    """ 角色急救水平高 """
    FIRST_AID_SKILLS_IS_LOW = "first_aid_skills_is_low"
    """ 角色急救水平低 """
    ANATOMY_SKILLS_IS_HEIGHT = "anatomy_skills_is_height"
    """ 角色解剖水平高 """
    ANATOMY_SKILLS_IS_LOW = "anatomy_skills_is_low"
    """ 角色解剖水平低 """
    PLAY_MUSIC_SKILLS_IS_HEIGHT = "play_music_skills_is_height"
    """ 角色演奏水平高 """
    PLAY_MUSIC_SKILLS_IS_LOW = "play_music_skills_is_low"
    """ 角色演奏水平低 """
    PROGRAMMING_SKILLS_IS_HEIGHT = "programming_skills_is_height"
    """ 角色编程水平高 """
    PROGRAMMING_SKILLS_IS_LOW = "programming_skills_is_low"
    """ 角色编程水平低 """
    HACKER_SKILLS_IS_HEIGHT = "hacker_skills_is_height"
    """ 角色黑客水平高 """
    HACKER_SKILLS_IS_LOW = "hacker_skills_is_low"
    """ 角色黑客水平低 """
    WRITE_SKILLS_IS_HEIGHT = "write_skills_is_height"
    """ 角色写作水平高 """
    WRITE_SKILLS_IS_LOW = "write_skills_is_low"
    """ 角色写作水平低 """
    TRANSACTION_SKILLS_IS_HEIGHT = "transaction_skills_is_height"
    """ 角色交易水平高 """
    TRANSACTION_SKILLS_IS_LOW = "transaction_skills_is_low"
    """ 角色交易水平低 """
    CEREMONY_SKILLS_IS_HEIGHT = "ceremony_skills_is_height"
    """ 角色礼仪水平高 """
    CEREMONY_SKILLS_IS_LOW = "ceremont_skills_is_low"
    """ 角色礼仪水平低 """
    MOTION_SKILLS_IS_HEIGHT = "motion_skills_is_height"
    """ 角色运动水平高 """
    MOTION_SKILLS_IS_LOW = "motion_skills_is_low"
    """ 角色运动水平低 """

    """
    =========================
    角色科学知识技能类前提
    =========================
    """
    MECHANICS_SKILLS_IS_HEIGHT = "mechanics_skills_is_height"
    """ 角色机械学水平高 """
    MECHANICS_SKILLS_IS_LOW = "mechanics_skills_is_low"
    """ 角色机械学水平低 """
    ELECTRONICS_SKILLS_IS_HEIGHT = "electronics_skills_is_height"
    """ 角色电子学水平高 """
    ELECTRONICS_SKILLS_IS_LOW = "electronics_skills_is_low"
    """ 角色电子学水平低 """
    COMPUTER_SCIENCE_SKILLS_IS_HEIGHT = "computer_science_skills_is_height"
    """ 角色计算机学水平高 """
    COMPUTER_SCIENCE_SKILLS_IS_LOW = "computer_science_skills_is_low"
    """ 角色计算机学水平低 """
    CRYPTOGRAPHY_SKILLS_IS_HEIGHT = "cryptography_skills_is_height"
    """ 角色密码学水平高 """
    CRYPTOGRAPHY_SKILLS_IS_LOW = "cryptography_skills_is_low"
    """ 角色密码学水平低 """
    CHEMISTRY_SKILLS_IS_HEIGHT = "chemistry_skills_is_height"
    """ 角色化学水平高 """
    CHEMISTRY_SKILLS_IS_LOW = "chemistry_skills_is_low"
    """ 角色化学水平低 """
    BIOLOGY_SKILLS_IS_HEIGHT = "biology_skills_is_height"
    """ 角色生物学水平高 """
    BIOLOGY_SKILLS_IS_LOW = "biology_skills_is_low"
    """ 角色生物学水平低 """
    MATHEMATICS_SKILLS_IS_HEIGHT = "mathematics_skills_is_height"
    """ 角色数学水平高 """
    MATHEMATICS_SKILLS_IS_LOW = "mathematics_skills_is_low"
    """ 角色数学水平低 """
    ASTRONOMY_SKILLS_IS_HEIGHT = "astronomy_skills_is_height"
    """ 角色天文学水平高 """
    ASTRONOMY_SKILLS_IS_LOW = "astronomy_skills_is_low"
    """ 角色天文学水平低 """
    PHYSICS_SKILLS_IS_HEIGHT = "physics_skills_is_height"
    """ 角色物理学水平高 """
    PHYSICS_SKILLS_IS_LOW = "physics_skills_is_low"
    """ 角色物理学水平低 """
    GEOGRAPHY_SKILLS_IS_HEIGHT = "geography_skills_is_height"
    """ 角色地理学水平高 """
    GEOGRAPHY_SKILLS_IS_LOW = "geography_skills_is_low"
    """ 角色地理学水平低 """
    GEOLOGY_SKILLS_IS_HEIGHT = "geology_skills_is_height"
    """ 角色地质学水平高 """
    GEOLOGY_SKILLS_IS_LOW = "geology_skills_is_low"
    """ 角色地质学水平低 """
    ECOLOGY_SKILLS_IS_HEIGHT = "ecology_skills_is_height"
    """ 角色生态学水平高 """
    ECOLOGY_SKILLS_IS_LOW = "ecology_skills_is_low"
    """ 角色生态学水平低 """
    ZOOLOGY_SKILLS_IS_HEIGHT = "zoology_skills_is_height"
    """ 角色动物学水平高 """
    ZOOLOGY_SKILLS_IS_LOW = "zoology_skills_is_low"
    """ 角色动物学水平低 """
    BOTANY_SKILLS_IS_HEIGHT = "botany_skills_is_height"
    """ 角色植物学水平高 """
    BOTANY_SKILLS_IS_LOW = "botany_skills_is_low"
    """ 角色植物学水平低 """
    ENTOMOLOGY_SKILLS_IS_HEIGHT = "entomology_skills_is_height"
    """ 角色昆虫学水平高 """
    ENTOMOLOGY_SKILLS_IS_LOW = "entomology_skills_is_low"
    """ 角色昆虫学水平低 """
    MICROBIOLOGY_SKILLS_IS_HEIGHT = "microbiology_skills_is_height"
    """ 角色微生物学水平高 """
    MICROBIOLOGY_SKILLS_IS_LOW = "microbiology_skills_is_low"
    """ 角色微生物学水平低 """
    VIROLOGY_SKILLS_IS_HEIGHT = "virology_skills_is_height"
    """ 角色病毒学水平高 """
    VIROLOGY_SKILLS_IS_LOW = "virology_skills_is_low"
    """ 角色病毒学水平低 """
    BECTERIOLOGY_SKILLS_IS_HEIGHT = "becteriology_skills_is_height"
    """ 角色细菌学水平高 """
    BECTERIOLOGY_SKILLS_IS_LOW = "becteriology_skills_is_low"
    """ 角色细菌学水平低 """
    MYCOLOGY_SKILLS_IS_HEIGHT = "mycology_skills_is_height"
    """ 角色真菌学水平高 """
    MYCOLOGY_SKILLS_IS_LOW = "mycology_skills_is_low"
    """ 角色真菌学水平低 """
    PHARMACY_SKILLS_IS_HEIGHT = "pharmacy_skills_is_height"
    """ 角色药学水平高 """
    PHARMACY_SKILLS_IS_LOW = "pharmacy_skills_is_low"
    """ 角色药学水平低 """
    METEOROLOGY_SKILLS_IS_HEIGHT = "meteorology_skills_is_height"
    """ 角色气象学水平高 """
    METEOROLOGY_SKILLS_IS_LOW = "meteorology_skills_is_low"
    """ 角色气象学水平低 """
    LAW_SCIENCE_SKILLS_IS_HEIGHT = "law_science_skills_is_height"
    """ 角色法学水平高 """
    LAW_SCIENCE_SKILLS_IS_LOW = "law_science_skills_is_low"
    """ 角色法学水平低 """
    LINGUISTICS_SKILLS_IS_HEIGHT = "linguistics_skills_is_height"
    """ 角色语言学水平高 """
    LINGUISTICS_SKILLS_IS_LOW = "linguistics_skills_is_low"
    """ 角色语言学水平低 """

    """
    =========================
    角色神秘学技能类前提
    =========================
    """
    APOTHECARY_SKILLS_IS_HEIGHT = "apothecary_skills_is_height"
    """ 角色炼金学水平高 """
    APOTHECARY_SKILLS_IS_LOW = "apothecary_skills_is_low"
    """ 角色炼金学水平低 """
    PARAPSYCHOLOGIES_SKILLS_IS_HEIGHT = "parapsychologies_skills_is_height"
    """ 角色通灵学水平高 """
    PARAPSYCHOLOGIES_SKILLS_IS_LOW = "parapsychologies_skills_is_low"
    """ 角色通灵学水平低 """
    NUMEROLOGY_SKILLS_IS_HEIGHT = "numerology_skills_is_height"
    """ 角色灵数学水平高 """
    NUMEROLOGY_SKILLS_IS_LOW = "numerology_skills_is_low"
    """ 角色灵数学水平低 """
    PRACTISE_DIVINATION_SKILLS_IS_HEIGHT = "practise_divination_skills_is_height"
    """ 角色占卜学水平高 """
    PRACTISE_DIVINATION_SKILLS_IS_LOW = "practise_divination_skills_is_low"
    """ 角色占卜学水平低 """
    PROPHECY_SKILLS_IS_HEIGHT = "prophecy_skills_is_height"
    """ 角色预言学水平高 """
    PROPHECY_SKILLS_IS_LOW = "prophecy_skills_is_low"
    """ 角色预言学水平低 """
    ASTROLOGY_SKILLS_IS_HEIGHT = "astrology_skills_is_height"
    """ 角色占星学水平高 """
    ASTROLOGY_SKILLS_IS_LOW = "astrology_skills_is_low"
    """ 角色占星学水平低 """
    DEMONOLOGY_SKILLS_IS_HEIGHT = "demonology_skills_is_height"
    """ 角色恶魔学水平高 """
    DEMONOLOGY_SKILLS_IS_LOW = "demonology_skills_is_low"
    """ 角色恶魔学水平低 """
    RITUAL_SKILLS_IS_HEIGHT = "ritual_skills_is_height"
    """ 角色仪式学水平高 """
    RITUAL_SKILLS_IS_LOW = "ritual_skills_is_low"
    """ 角色仪式学水平低 """

    """
    =========================
    角色语言技能类前提
    =========================
    """
    CHINESE_SKILLS_IS_HEIGHT = "chinese_skills_is_height"
    """ 角色汉语水平高 """
    CHINESE_SKILLS_IS_LOW = "chinese_skills_is_low"
    """ 角色汉语水平低 """
    ENGLISH_SKILLS_IS_HEIGHT = "english_skills_is_height"
    """ 角色英语水平高 """
    ENGLISH_SKILLS_IS_LOW = "english_skills_is_low"
    """ 角色英语水平低 """
    FRENCH_SKILLS_IS_HEIGHT = "french_skills_is_height"
    """ 角色法语水平高 """
    FRENCH_SKILLS_IS_LOW = "french_skills_is_low"
    """ 角色法语水平低 """
    SPANISH_SKILLS_IS_HEIGHT = "spanish_skills_is_height"
    """ 角色西班牙语水平高 """
    SPANISH_SKILLS_IS_LOW = "spanish_skills_is_low"
    """ 角色西班牙语水平低 """
    ARABIC_SKILLS_IS_HEIGHT = "arabic_skills_is_height"
    """ 角色阿拉伯语水平高 """
    ARABIC_SKILLS_IS_LOW = "arabic_skills_is_low"
    """ 角色阿拉伯语水平低 """
    RUSSIAN_SKILLS_IS_HEIGHT = "russian_skills_is_height"
    """ 角色俄语水平高 """
    RUSSIAN_SKILLS_IS_LOW = "russian_skills_is_low"
    """ 角色俄语水平低 """
    JAPANESE_SKILLS_IS_HEIGHT = "japanese_skills_is_height"
    """ 角色日语水平高 """
    JAPANESE_SKILLS_IS_LOW = "japanese_skills_is_low"
    """ 角色日语水平低 """
    HINDI_SKILLS_IS_HEIGHT = "hindi_skills_is_height"
    """ 角色印地语水平高 """
    HINDI_SKILLS_IS_LOW = "hindi_skills_is_low"
    """ 角色印地语水平低 """
    OLD_LATIN_SKILLS_IS_HEIGHT = "old_latin_skills_is_height"
    """ 角色古拉丁语水平高 """
    OLD_LATIN_SKILLS_IS_LOW = "old_latin_skills_is_low"
    """ 角色古拉丁语水平低 """
    LATIN_SKILLS_IS_HEIGHT = "latin_skills_is_height"
    """ 角色拉丁语水平高 """
    LATIN_SKILLS_IS_LOW = "latin_skills_is_low"
    """ 角色拉丁语水平低 """
    ANCIENT_CHINESE_SKILLS_IS_HEIGHT = "ancient_chinese_skills_is_height"
    """ 角色古汉语水平高 """
    ANCIENT_CHINESE_SKILLS_IS_LOW = "ancient_chinese_skills_is_low"
    """ 角色古汉语水平低 """
    OLD_SINITIC_SKILLS_IS_HEIGHT = "old_sinitic_skills_is_height"
    """ 角色上古汉语水平高 """
    OLD_SINITIC_SKILLS_IS_LOW = "old_sinitic_skills_is_low"
    """ 角色上古汉语水平低 """

    """
    =========================
    角色人文天赋类前提
    =========================
    """
    ETHIC_INTEREST_IS_HEIGHT = "ethic_interest_is_height"
    """ 角色伦理天赋水平高 """
    ETHIC_INTEREST_IS_LOW = "ethic_interest_is_low"
    """ 角色伦理天赋水平低 """
    MORALITY_INTEREST_IS_HEIGHT = "morality_interest_is_height"
    """ 角色道德天赋水平高 """
    MORALITY_INTEREST_IS_LOW = "morality_interest_is_low"
    """ 角色道德天赋水平低 """
    LITERATURE_INTEREST_IS_HEIGHT = "literature_interest_is_height"
    """ 角色文学天赋水平高 """
    LITERATURE_INTEREST_IS_LOW = "literature_interest_is_low"
    """ 角色文学天赋水平低 """
    POETRY_INTEREST_IS_HEIGHT = "poetry_interest_is_height"
    """ 角色诗歌天赋水平高 """
    POETRY_INTEREST_IS_LOW = "poetry_interest_is_low"
    """ 角色诗歌天赋水平低 """
    HISTORY_INTEREST_IS_HEIGHT = "history_interest_is_height"
    """ 角色历史天赋水平高 """
    HISTORY_INTEREST_IS_LOW = "history_interest_is_low"
    """ 角色历史天赋水平低 """
    ART_INTEREST_IS_HEIGHT = "art_interest_is_height"
    """ 角色艺术天赋水平高 """
    ART_INTEREST_IS_LOW = "art_interest_is_low"
    """ 角色艺术天赋水平低 """
    MUSIC_THEORY_INTEREST_IS_HEIGHT = "music_theory_interest_is_height"
    """ 角色乐理天赋水平高 """
    MUSIC_THEORY_INTEREST_IS_LOW = "music_theory_interest_is_low"
    """ 角色乐理天赋水平低 """
    RELIGION_INTEREST_IS_HEIGHT = "religion_interest_is_height"
    """ 角色宗教天赋水平高 """
    RELIGION_INTEREST_IS_LOW = "religion_interest_is_low"
    """ 角色宗教天赋水平低 """
    FAITH_INTEREST_IS_HEIGHT = "faith_interest_is_height"
    """ 角色信仰天赋水平高 """
    FAITH_INTEREST_IS_LOW = "faith_interest_is_low"
    """ 角色信仰天赋水平低 """

    """
    =========================
    角色技巧天赋类前提
    =========================
    """
    SEXUAL_SKILLS_INTEREST_IS_HEIGHT = "sexual_skills_interest_is_height"
    """ 角色性爱天赋水平高 """
    SEXUAL_SKILLS_INTEREST_IS_LOW = "sexual_skills_interest_is_low"
    """ 角色性爱天赋水平低 """
    COMPUTER_SKILLS_INTEREST_IS_HEIGHT = "computer_skills_interest_is_height"
    """ 角色计算机天赋水平高 """
    COMPUTER_SKILLS_INTEREST_IS_LOW = "computer_skills_interest_is_low"
    """ 角色计算机天赋水平低 """
    PERFORMANCE_SKILLS_INTEREST_IS_HEIGHT = "performance_skills_interest_is_height"
    """ 角色表演天赋水平高 """
    PERFORMANCE_SKILLS_INTEREST_IS_LOW = "perform_skills_interest_is_low"
    """ 角色表演天赋水平低 """
    ELOQUENCE_SKILLS_INTEREST_IS_HEIGHT = "eloquence_skills_interest_is_height"
    """ 角色口才天赋水平高 """
    ELOQUENCE_SKILLS_INTEREST_IS_LOW = "eloquence_skills_interest_is_low"
    """ 角色口才天赋水平低 """
    PAINTING_SKILLS_INTEREST_IS_HEIGHT = "painting_skills_interest_is_height"
    """ 角色绘画天赋水平高 """
    PAINTING_SKILLS_INTEREST_IS_LOW = "painting_skills_interest_is_low"
    """ 角色绘画天赋水平低 """
    SHOOT_SKILLS_INTEREST_IS_HEIGHT = "shoot_skills_interest_is_height"
    """ 角色拍摄天赋水平高 """
    SHOOT_SKILLS_INTEREST_IS_LOW = "shoot_skills_interest_is_low"
    """ 角色拍摄天赋水平低 """
    SINGING_SKILLS_INTEREST_IS_HEIGHT = "singing_skills_interest_is_height"
    """ 角色演唱天赋水平高 """
    SINGING_SKILLS_INTEREST_IS_LOW = "singing_skills_interest_is_low"
    """ 角色演唱天赋水平低 """
    WRITE_MUSIC_SKILLS_INTEREST_IS_HEIGHT = "write_music_skills_interest_is_height"
    """ 角色作曲天赋水平高 """
    WRITE_MUSIC_SKILLS_INTEREST_IS_LOW = "write_music_skills_interest_is_low"
    """ 角色作曲天赋水平低 """
    COOKING_SKILLS_INTEREST_IS_HEIGHT = "cooking_skills_interest_is_height"
    """ 角色厨艺天赋水平高 """
    COOKING_SKILLS_INTEREST_IS_LOW = "cooking_skills_interest_is_low"
    """ 角色厨艺天赋水平低 """
    DANCE_SKILLS_INTEREST_IS_HEIGHT = "dance_skills_interest_is_height"
    """ 角色舞蹈天赋水平高 """
    DANCE_SKILLS_INTEREST_IS_LOW = "dance_skills_interest_is_low"
    """ 角色舞蹈天赋水平低 """
    TAILOR_SKILLS_INTEREST_IS_HEIGHT = "tailor_skills_interest_is_height"
    """ 角色裁缝天赋水平高 """
    TAILOR_SKILLS_INTEREST_IS_LOW = "tailor_skills_interest_is_low"
    """ 角色裁缝天赋水平低 """
    TACTICS_SKILLS_INTEREST_IS_HEIGHT = "tactics_skills_interest_is_height"
    """ 角色战术天赋水平高 """
    TACTICS_SKILLS_INTEREST_IS_LOW = "tactics_skills_interest_is_low"
    """ 角色战术天赋水平低 """
    SWIMMING_SKILLS_INTEREST_IS_HEIGHT = "swimming_skills_interest_is_height"
    """ 角色游泳天赋水平高 """
    SWIMMING_SKILLS_INTEREST_IS_LOW = "swimming_skills_interest_is_low"
    """ 角色游泳天赋水平低 """
    MANUFACTURE_SKILLS_INTEREST_IS_HEIGHT = "manufacture_skills_interest_is_height"
    """ 角色制造天赋水平高 """
    MANUFACTURE_SKILLS_INTEREST_IS_LOW = "manufacture_skills_interest_is_low"
    """ 角色制造天赋水平低 """
    FIRST_AID_SKILLS_INTEREST_IS_HEIGHT = "first_aid_skills_interest_is_height"
    """ 角色急救天赋水平高 """
    FIRST_AID_SKILLS_INTEREST_IS_LOW = "first_aid_skills_interest_is_low"
    """ 角色急救天赋水平低 """
    ANATOMY_SKILLS_INTEREST_IS_HEIGHT = "anatomy_skills_interest_is_height"
    """ 角色解剖天赋水平高 """
    ANATOMY_SKILLS_INTEREST_IS_LOW = "anatomy_skills_interest_is_low"
    """ 角色解剖天赋水平低 """
    PLAY_MUSIC_SKILLS_INTEREST_IS_HEIGHT = "play_music_skills_interest_is_height"
    """ 角色演奏天赋水平高 """
    PLAY_MUSIC_SKILLS_INTEREST_IS_LOW = "play_music_skills_interest_is_low"
    """ 角色演奏天赋水平低 """
    PROGRAMMING_SKILLS_INTEREST_IS_HEIGHT = "programming_skills_interest_is_height"
    """ 角色编程天赋水平高 """
    PROGRAMMING_SKILLS_INTEREST_IS_LOW = "programming_skills_interest_is_low"
    """ 角色编程天赋水平低 """
    HACKER_SKILLS_INTEREST_IS_HEIGHT = "hacker_skills_interest_is_height"
    """ 角色黑客天赋水平高 """
    HACKER_SKILLS_INTEREST_IS_LOW = "hacker_skills_interest_is_low"
    """ 角色黑客天赋水平低 """
    WRITE_SKILLS_INTEREST_IS_HEIGHT = "write_skills_interest_is_height"
    """ 角色写作天赋水平高 """
    WRITE_SKILLS_INTEREST_IS_LOW = "write_skills_interest_is_low"
    """ 角色写作天赋水平低 """
    TRANSACTION_SKILLS_INTEREST_IS_HEIGHT = "transaction_skills_interest_is_height"
    """ 角色交易天赋水平高 """
    TRANSACTION_SKILLS_INTEREST_IS_LOW = "transaction_skills_interest_is_low"
    """ 角色交易天赋水平低 """
    CEREMONY_SKILLS_INTEREST_IS_HEIGHT = "ceremony_skills_interest_is_height"
    """ 角色礼仪天赋水平高 """
    CEREMONY_SKILLS_INTEREST_IS_LOW = "ceremont_skills_interest_is_low"
    """ 角色礼仪天赋水平低 """
    MOTION_SKILLS_INTEREST_IS_HEIGHT = "motion_skills_interest_is_height"
    """ 角色运动天赋水平高 """
    MOTION_SKILLS_INTEREST_IS_LOW = "motion_skills_interest_is_low"
    """ 角色运动天赋水平低 """

    """
    =========================
    角色科学知识天赋类前提
    =========================
    """
    MECHANICS_SKILLS_INTEREST_IS_HEIGHT = "mechanics_skills_interest_is_height"
    """ 角色机械学天赋水平高 """
    MECHANICS_SKILLS_INTEREST_IS_LOW = "mechanics_skills_interest_is_low"
    """ 角色机械学天赋水平低 """
    ELECTRONICS_SKILLS_INTEREST_IS_HEIGHT = "electronics_skills_interest_is_height"
    """ 角色电子学天赋水平高 """
    ELECTRONICS_SKILLS_INTEREST_IS_LOW = "electronics_skills_interest_is_low"
    """ 角色电子学天赋水平低 """
    COMPUTER_SCIENCE_SKILLS_INTEREST_IS_HEIGHT = "computer_science_skills_interest_is_height"
    """ 角色计算机学天赋水平高 """
    COMPUTER_SCIENCE_SKILLS_INTEREST_IS_LOW = "computer_science_skills_interest_is_low"
    """ 角色计算机学天赋水平低 """
    CRYPTOGRAPHY_SKILLS_INTEREST_IS_HEIGHT = "cryptography_skills_interest_is_height"
    """ 角色密码学天赋水平高 """
    CRYPTOGRAPHY_SKILLS_INTEREST_IS_LOW = "cryptography_skills_interest_is_low"
    """ 角色密码学天赋水平低 """
    CHEMISTRY_SKILLS_INTEREST_IS_HEIGHT = "chemistry_skills_interest_is_height"
    """ 角色化学天赋水平高 """
    CHEMISTRY_SKILLS_INTEREST_IS_LOW = "chemistry_skills_interest_is_low"
    """ 角色化学天赋水平低 """
    BIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "biology_skills_interest_is_height"
    """ 角色生物学天赋水平高 """
    BIOLOGY_SKILLS_INTEREST_IS_LOW = "biology_skills_interest_is_low"
    """ 角色生物学天赋水平低 """
    MATHEMATICS_SKILLS_INTEREST_IS_HEIGHT = "mathematics_skills_interest_is_height"
    """ 角色数学天赋水平高 """
    MATHEMATICS_SKILLS_INTEREST_IS_LOW = "mathematics_skills_interest_is_low"
    """ 角色数学天赋水平低 """
    ASTRONOMY_SKILLS_INTEREST_IS_HEIGHT = "astronomy_skills_interest_is_height"
    """ 角色天文学天赋水平高 """
    ASTRONOMY_SKILLS_INTEREST_IS_LOW = "astronomy_skills_interest_is_low"
    """ 角色天文学天赋水平低 """
    PHYSICS_SKILLS_INTEREST_IS_HEIGHT = "physics_skills_interest_is_height"
    """ 角色物理学天赋水平高 """
    PHYSICS_SKILLS_INTEREST_IS_LOW = "physics_skills_interest_is_low"
    """ 角色物理学天赋水平低 """
    GEOGRAPHY_SKILLS_INTEREST_IS_HEIGHT = "geography_skills_interest_is_height"
    """ 角色地理学天赋水平高 """
    GEOGRAPHY_SKILLS_INTEREST_IS_LOW = "geography_skills_interest_is_low"
    """ 角色地理学天赋水平低 """
    GEOLOGY_SKILLS_INTEREST_IS_HEIGHT = "geology_skills_interest_is_height"
    """ 角色地质学天赋水平高 """
    GEOLOGY_SKILLS_INTEREST_IS_LOW = "geology_skills_interest_is_low"
    """ 角色地质学天赋水平低 """
    ECOLOGY_SKILLS_INTEREST_IS_HEIGHT = "ecology_skills_interest_is_height"
    """ 角色生态学天赋水平高 """
    ECOLOGY_SKILLS_INTEREST_IS_LOW = "ecology_skills_interest_is_low"
    """ 角色生态学天赋水平低 """
    ZOOLOGY_SKILLS_INTEREST_IS_HEIGHT = "zoology_skills_interest_is_height"
    """ 角色动物学天赋水平高 """
    ZOOLOGY_SKILLS_INTEREST_IS_LOW = "zoology_skills_interest_is_low"
    """ 角色动物学天赋水平低 """
    BOTANY_SKILLS_INTEREST_IS_HEIGHT = "botany_skills_interest_is_height"
    """ 角色植物学天赋水平高 """
    BOTANY_SKILLS_INTEREST_IS_LOW = "botany_skills_interest_is_low"
    """ 角色植物学天赋水平低 """
    ENTOMOLOGY_SKILLS_INTEREST_IS_HEIGHT = "entomology_skills_interest_is_height"
    """ 角色昆虫学天赋水平高 """
    ENTOMOLOGY_SKILLS_INTEREST_IS_LOW = "entomology_skills_interest_is_low"
    """ 角色昆虫学天赋水平低 """
    MICROBIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "microbiology_skills_interest_is_height"
    """ 角色微生物学天赋水平高 """
    MICROBIOLOGY_SKILLS_INTEREST_IS_LOW = "microbiology_skills_interest_is_low"
    """ 角色微生物学天赋水平低 """
    VIROLOGY_SKILLS_INTEREST_IS_HEIGHT = "virology_skills_interest_is_height"
    """ 角色病毒学天赋水平高 """
    VIROLOGY_SKILLS_INTEREST_IS_LOW = "virology_skills_interest_is_low"
    """ 角色病毒学天赋水平低 """
    BECTERIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "becteriology_skills_interest_is_height"
    """ 角色细菌学天赋水平高 """
    BECTERIOLOGY_SKILLS_INTEREST_IS_LOW = "becteriology_skills_interest_is_low"
    """ 角色细菌学天赋水平低 """
    MYCOLOGY_SKILLS_INTEREST_IS_HEIGHT = "mycology_skills_interest_is_height"
    """ 角色真菌学天赋水平高 """
    MYCOLOGY_SKILLS_INTEREST_IS_LOW = "mycology_skills_interest_is_low"
    """ 角色真菌学天赋水平低 """
    PHARMACY_SKILLS_INTEREST_IS_HEIGHT = "pharmacy_skills_interest_is_height"
    """ 角色药学天赋水平高 """
    PHARMACY_SKILLS_INTEREST_IS_LOW = "pharmacy_skills_interest_is_low"
    """ 角色药学天赋水平低 """
    METEOROLOGY_SKILLS_INTEREST_IS_HEIGHT = "meteorology_skills_interest_is_height"
    """ 角色气象学天赋水平高 """
    METEOROLOGY_SKILLS_INTEREST_IS_LOW = "meteorology_skills_interest_is_low"
    """ 角色气象学天赋水平低 """
    LAW_SCIENCE_SKILLS_INTEREST_IS_HEIGHT = "law_science_skills_interest_is_height"
    """ 角色法学天赋水平高 """
    LAW_SCIENCE_SKILLS_INTEREST_IS_LOW = "law_science_skills_interest_is_low"
    """ 角色法学天赋水平低 """
    LINGUISTICS_SKILLS_INTEREST_IS_HEIGHT = "linguistics_skills_interest_is_height"
    """ 角色语言学天赋水平高 """
    LINGUISTICS_SKILLS_INTEREST_IS_LOW = "linguistics_skills_interest_is_low"
    """ 角色语言学天赋水平低 """

    """
    =========================
    角色神秘学天赋类前提
    =========================
    """
    APOTHECARY_SKILLS_INTEREST_IS_HEIGHT = "apothecary_skills_interest_is_height"
    """ 角色炼金学天赋水平高 """
    APOTHECARY_SKILLS_INTEREST_IS_LOW = "apothecary_skills_interest_is_low"
    """ 角色炼金学天赋水平低 """
    PARAPSYCHOLOGIES_SKILLS_INTEREST_IS_HEIGHT = "parapsychologies_skills_interest_is_height"
    """ 角色通灵学天赋水平高 """
    PARAPSYCHOLOGIES_SKILLS_INTEREST_IS_LOW = "parapsychologies_skills_interest_is_low"
    """ 角色通灵学天赋水平低 """
    NUMEROLOGY_SKILLS_INTEREST_IS_HEIGHT = "numerology_skills_interest_is_height"
    """ 角色灵数学天赋水平高 """
    NUMEROLOGY_SKILLS_INTEREST_IS_LOW = "numerology_skills_interest_is_low"
    """ 角色灵数学天赋水平低 """
    PRACTISE_DIVINATION_SKILLS_INTEREST_IS_HEIGHT = "practise_divination_skills_interest_is_height"
    """ 角色占卜学天赋水平高 """
    PRACTISE_DIVINATION_SKILLS_INTEREST_IS_LOW = "practise_divination_skills_interest_is_low"
    """ 角色占卜学天赋水平低 """
    PROPHECY_SKILLS_INTEREST_IS_HEIGHT = "prophecy_skills_interest_is_height"
    """ 角色预言学天赋水平高 """
    PROPHECY_SKILLS_INTEREST_IS_LOW = "prophecy_skills_interest_is_low"
    """ 角色预言学天赋水平低 """
    ASTROLOGY_SKILLS_INTEREST_IS_HEIGHT = "astrology_skills_interest_is_height"
    """ 角色占星学天赋水平高 """
    ASTROLOGY_SKILLS_INTEREST_IS_LOW = "astrology_skills_interest_is_low"
    """ 角色占星学天赋水平低 """
    DEMONOLOGY_SKILLS_INTEREST_IS_HEIGHT = "demonology_skills_interest_is_height"
    """ 角色恶魔学天赋水平高 """
    DEMONOLOGY_SKILLS_INTEREST_IS_LOW = "demonology_skills_interest_is_low"
    """ 角色恶魔学天赋水平低 """
    RITUAL_SKILLS_INTEREST_IS_HEIGHT = "ritual_skills_interest_is_height"
    """ 角色仪式学天赋水平高 """
    RITUAL_SKILLS_INTEREST_IS_LOW = "ritual_skills_interest_is_low"
    """ 角色仪式学天赋水平低 """

    """
    =========================
    角色语言天赋类前提
    =========================
    """
    CHINESE_SKILLS_INTEREST_IS_HEIGHT = "chinese_skills_interest_is_height"
    """ 角色汉语天赋水平高 """
    CHINESE_SKILLS_INTEREST_IS_LOW = "chinese_skills_interest_is_low"
    """ 角色汉语天赋水平低 """
    ENGLISH_SKILLS_INTEREST_IS_HEIGHT = "english_skills_interest_is_height"
    """ 角色英语天赋水平高 """
    ENGLISH_SKILLS_INTEREST_IS_LOW = "english_skills_interest_is_low"
    """ 角色英语天赋水平低 """
    FRENCH_SKILLS_INTEREST_IS_HEIGHT = "french_skills_interest_is_height"
    """ 角色法语天赋水平高 """
    FRENCH_SKILLS_INTEREST_IS_LOW = "french_skills_interest_is_low"
    """ 角色法语天赋水平低 """
    SPANISH_SKILLS_INTEREST_IS_HEIGHT = "spanish_skills_interest_is_height"
    """ 角色西班牙语天赋水平高 """
    SPANISH_SKILLS_INTEREST_IS_LOW = "spanish_skills_interest_is_low"
    """ 角色西班牙语天赋水平低 """
    ARABIC_SKILLS_INTEREST_IS_HEIGHT = "arabic_skills_interest_is_height"
    """ 角色阿拉伯语天赋水平高 """
    ARABIC_SKILLS_INTEREST_IS_LOW = "arabic_skills_interest_is_low"
    """ 角色阿拉伯语天赋水平低 """
    RUSSIAN_SKILLS_INTEREST_IS_HEIGHT = "russian_skills_interest_is_height"
    """ 角色俄语天赋水平高 """
    RUSSIAN_SKILLS_INTEREST_IS_LOW = "russian_skills_interest_is_low"
    """ 角色俄语天赋水平低 """
    JAPANESE_SKILLS_INTEREST_IS_HEIGHT = "japanese_skills_interest_is_height"
    """ 角色日语天赋水平高 """
    JAPANESE_SKILLS_INTEREST_IS_LOW = "japanese_skills_interest_is_low"
    """ 角色日语天赋水平低 """
    HINDI_SKILLS_INTEREST_IS_HEIGHT = "hindi_skills_interest_is_height"
    """ 角色印地语天赋水平高 """
    HINDI_SKILLS_INTEREST_IS_LOW = "hindi_skills_interest_is_low"
    """ 角色印地语天赋水平低 """
    OLD_LATIN_SKILLS_INTEREST_IS_HEIGHT = "old_latin_skills_interest_is_height"
    """ 角色古拉丁语天赋水平高 """
    OLD_LATIN_SKILLS_INTEREST_IS_LOW = "old_latin_skills_interest_is_low"
    """ 角色古拉丁语天赋水平低 """
    LATIN_SKILLS_INTEREST_IS_HEIGHT = "latin_skills_interest_is_height"
    """ 角色拉丁语天赋水平高 """
    LATIN_SKILLS_INTEREST_IS_LOW = "latin_skills_interest_is_low"
    """ 角色拉丁语天赋水平低 """
    ANCIENT_CHINESE_SKILLS_INTEREST_IS_HEIGHT = "ancient_chinese_skills_interest_is_height"
    """ 角色古汉语天赋水平高 """
    ANCIENT_CHINESE_SKILLS_INTEREST_IS_LOW = "ancient_chinese_skills_interest_is_low"
    """ 角色古汉语天赋水平低 """
    OLD_SINITIC_SKILLS_INTEREST_IS_HEIGHT = "old_sinitic_skills_interest_is_height"
    """ 角色上古汉语天赋水平高 """
    OLD_SINITIC_SKILLS_INTEREST_IS_LOW = "old_sinitic_skills_interest_is_low"
    """ 角色上古汉语天赋水平低 """

    """
    =========================
    交互对象人文技能类前提
    =========================
    """
    TARGET_ETHIC_IS_HEIGHT = "target_ethic_is_height"
    """ 交互对象伦理水平高 """
    TARGET_ETHIC_IS_LOW = "target_ethic_is_low"
    """ 交互对象伦理水平低 """
    TARGET_MORALITY_IS_HEIGHT = "target_morality_is_height"
    """ 交互对象道德水平高 """
    TARGET_MORALITY_IS_LOW = "target_morality_is_low"
    """ 交互对象道德水平低 """
    TARGET_LITERATURE_IS_HEIGHT = "target_literature_is_height"
    """ 交互对象文学水平高 """
    TARGET_LITERATURE_IS_LOW = "target_literature_is_low"
    """ 交互对象文学水平低 """
    TARGET_POETRY_IS_HEIGHT = "target_poetry_is_height"
    """ 交互对象诗歌水平高 """
    TARGET_POETRY_IS_LOW = "target_poetry_is_low"
    """ 交互对象诗歌水平低 """
    TARGET_HISTORY_IS_HEIGHT = "target_history_is_height"
    """ 交互对象历史水平高 """
    TARGET_HISTORY_IS_LOW = "target_history_is_low"
    """ 交互对象历史水平低 """
    TARGET_ART_IS_HEIGHT = "target_art_is_height"
    """ 交互对象艺术水平高 """
    TARGET_ART_IS_LOW = "target_art_is_low"
    """ 交互对象艺术水平低 """
    TARGET_MUSIC_THEORY_IS_HEIGHT = "target_music_theory_is_height"
    """ 交互对象乐理水平高 """
    TARGET_MUSIC_THEORY_IS_LOW = "target_music_theory_is_low"
    """ 交互对象乐理水平低 """
    TARGET_RELIGION_IS_HEIGHT = "target_religion_is_height"
    """ 交互对象宗教水平高 """
    TARGET_RELIGION_IS_LOW = "target_religion_is_low"
    """ 交互对象宗教水平低 """
    TARGET_FAITH_IS_HEIGHT = "target_faith_is_height"
    """ 交互对象信仰水平高 """
    TARGET_FAITH_IS_LOW = "target_faith_is_low"
    """ 交互对象信仰水平低 """

    """
    =========================
    交互对象技巧技能类前提
    =========================
    """
    TARGET_SEXUAL_SKILLS_IS_HEIGHT = "target_sexual_skills_is_height"
    """ 交互对象性爱水平高 """
    TARGET_SEXUAL_SKILLS_IS_LOW = "target_sexual_skills_is_low"
    """ 交互对象性爱水平低 """
    TARGET_COMPUTER_SKILLS_IS_HEIGHT = "target_computer_skills_is_height"
    """ 交互对象计算机水平高 """
    TARGET_COMPUTER_SKILLS_IS_LOW = "target_computer_skills_is_low"
    """ 交互对象计算机水平低 """
    TARGET_PERFORMANCE_SKILLS_IS_HEIGHT = "target_performance_skills_is_height"
    """ 交互对象表演水平高 """
    TARGET_PERFORMANCE_SKILLS_IS_LOW = "target_perform_skills_is_low"
    """ 交互对象表演水平低 """
    TARGET_ELOQUENCE_SKILLS_IS_HEIGHT = "target_eloquence_skills_is_height"
    """ 交互对象口才水平高 """
    TARGET_ELOQUENCE_SKILLS_IS_LOW = "target_eloquence_skills_is_low"
    """ 交互对象口才水平低 """
    TARGET_PAINTING_SKILLS_IS_HEIGHT = "target_painting_skills_is_height"
    """ 交互对象绘画水平高 """
    TARGET_PAINTING_SKILLS_IS_LOW = "target_painting_skills_is_low"
    """ 交互对象绘画水平低 """
    TARGET_SHOOT_SKILLS_IS_HEIGHT = "target_shoot_skills_is_height"
    """ 交互对象拍摄水平高 """
    TARGET_SHOOT_SKILLS_IS_LOW = "target_shoot_skills_is_low"
    """ 交互对象拍摄水平低 """
    TARGET_SINGING_SKILLS_IS_HEIGHT = "target_singing_skills_is_height"
    """ 交互对象演唱水平高 """
    TARGET_SINGING_SKILLS_IS_LOW = "target_singing_skills_is_low"
    """ 交互对象演唱水平低 """
    TARGET_WRITE_MUSIC_SKILLS_IS_HEIGHT = "target_write_music_skills_is_height"
    """ 交互对象作曲水平高 """
    TARGET_WRITE_MUSIC_SKILLS_IS_LOW = "target_write_music_skills_is_low"
    """ 交互对象作曲水平低 """
    TARGET_COOKING_SKILLS_IS_HEIGHT = "target_cooking_skills_is_height"
    """ 交互对象厨艺水平高 """
    TARGET_COOKING_SKILLS_IS_LOW = "target_cooking_skills_is_low"
    """ 交互对象厨艺水平低 """
    TARGET_DANCE_SKILLS_IS_HEIGHT = "target_dance_skills_is_height"
    """ 交互对象舞蹈水平高 """
    TARGET_DANCE_SKILLS_IS_LOW = "target_dance_skills_is_low"
    """ 交互对象舞蹈水平低 """
    TARGET_TAILOR_SKILLS_IS_HEIGHT = "target_tailor_skills_is_height"
    """ 交互对象裁缝水平高 """
    TARGET_TAILOR_SKILLS_IS_LOW = "target_tailor_skills_is_low"
    """ 交互对象裁缝水平低 """
    TARGET_TACTICS_SKILLS_IS_HEIGHT = "target_tactics_skills_is_height"
    """ 交互对象战术水平高 """
    TARGET_TACTICS_SKILLS_IS_LOW = "target_tactics_skills_is_low"
    """ 交互对象战术水平低 """
    TARGET_SWIMMING_SKILLS_IS_HEIGHT = "target_swimming_skills_is_height"
    """ 交互对象游泳水平高 """
    TARGET_SWIMMING_SKILLS_IS_LOW = "target_swimming_skills_is_low"
    """ 交互对象游泳水平低 """
    TARGET_MANUFACTURE_SKILLS_IS_HEIGHT = "target_manufacture_skills_is_height"
    """ 交互对象制造水平高 """
    TARGET_MANUFACTURE_SKILLS_IS_LOW = "target_manufacture_skills_is_low"
    """ 交互对象制造水平低 """
    TARGET_FIRST_AID_SKILLS_IS_HEIGHT = "target_first_aid_skills_is_height"
    """ 交互对象急救水平高 """
    TARGET_FIRST_AID_SKILLS_IS_LOW = "target_first_aid_skills_is_low"
    """ 交互对象急救水平低 """
    TARGET_ANATOMY_SKILLS_IS_HEIGHT = "target_anatomy_skills_is_height"
    """ 交互对象解剖水平高 """
    TARGET_ANATOMY_SKILLS_IS_LOW = "target_anatomy_skills_is_low"
    """ 交互对象解剖水平低 """
    TARGET_PLAY_MUSIC_SKILLS_IS_HEIGHT = "target_play_music_skills_is_height"
    """ 交互对象演奏水平高 """
    TARGET_PLAY_MUSIC_SKILLS_IS_LOW = "target_play_music_skills_is_low"
    """ 交互对象演奏水平低 """
    TARGET_PROGRAMMING_SKILLS_IS_HEIGHT = "target_programming_skills_is_height"
    """ 交互对象编程水平高 """
    TARGET_PROGRAMMING_SKILLS_IS_LOW = "target_programming_skills_is_low"
    """ 交互对象编程水平低 """
    TARGET_HACKER_SKILLS_IS_HEIGHT = "target_hacker_skills_is_height"
    """ 交互对象黑客水平高 """
    TARGET_HACKER_SKILLS_IS_LOW = "target_hacker_skills_is_low"
    """ 交互对象黑客水平低 """
    TARGET_WRITE_SKILLS_IS_HEIGHT = "target_write_skills_is_height"
    """ 交互对象写作水平高 """
    TARGET_WRITE_SKILLS_IS_LOW = "target_write_skills_is_low"
    """ 交互对象写作水平低 """
    TARGET_TRANSACTION_SKILLS_IS_HEIGHT = "target_transaction_skills_is_height"
    """ 交互对象交易水平高 """
    TARGET_TRANSACTION_SKILLS_IS_LOW = "target_transaction_skills_is_low"
    """ 交互对象交易水平低 """
    TARGET_CEREMONY_SKILLS_IS_HEIGHT = "target_ceremony_skills_is_height"
    """ 交互对象礼仪水平高 """
    TARGET_CEREMONY_SKILLS_IS_LOW = "target_ceremony_skills_is_low"
    """ 交互对象礼仪水平低 """
    TARGET_MOTION_SKILLS_IS_HEIGHT = "target_motion_skills_is_height"
    """ 交互对象运动水平高 """
    TARGET_MOTION_SKILLS_IS_LOW = "target_motion_skills_is_low"
    """ 交互对象运动水平低 """

    """
    =========================
    交互对象科学知识技能类前提
    =========================
    """
    TARGET_MECHANICS_SKILLS_IS_HEIGHT = "target_mechanics_skills_is_height"
    """ 交互对象机械学水平高 """
    TARGET_MECHANICS_SKILLS_IS_LOW = "target_mechanics_skills_is_low"
    """ 交互对象机械学水平低 """
    TARGET_ELECTRONICS_SKILLS_IS_HEIGHT = "target_electronics_skills_is_height"
    """ 交互对象电子学水平高 """
    TARGET_ELECTRONICS_SKILLS_IS_LOW = "target_electronics_skills_is_low"
    """ 交互对象电子学水平低 """
    TARGET_COMPUTER_SCIENCE_SKILLS_IS_HEIGHT = "target_computer_science_skills_is_height"
    """ 交互对象计算机学水平高 """
    TARGET_COMPUTER_SCIENCE_SKILLS_IS_LOW = "target_computer_science_skills_is_low"
    """ 交互对象计算机学水平低 """
    TARGET_CRYPTOGRAPHY_SKILLS_IS_HEIGHT = "target_cryptography_skills_is_height"
    """ 交互对象密码学水平高 """
    TARGET_CRYPTOGRAPHY_SKILLS_IS_LOW = "target_cryptography_skills_is_low"
    """ 交互对象密码学水平低 """
    TARGET_CHEMISTRY_SKILLS_IS_HEIGHT = "target_chemistry_skills_is_height"
    """ 交互对象化学水平高 """
    TARGET_CHEMISTRY_SKILLS_IS_LOW = "target_chemistry_skills_is_low"
    """ 交互对象化学水平低 """
    TARGET_BIOLOGY_SKILLS_IS_HEIGHT = "target_biology_skills_is_height"
    """ 交互对象生物学水平高 """
    TARGET_BIOLOGY_SKILLS_IS_LOW = "target_biology_skills_is_low"
    """ 交互对象生物学水平低 """
    TARGET_MATHEMATICS_SKILLS_IS_HEIGHT = "target_mathematics_skills_is_height"
    """ 交互对象数学水平高 """
    TARGET_MATHEMATICS_SKILLS_IS_LOW = "target_mathematics_skills_is_low"
    """ 交互对象数学水平低 """
    TARGET_ASTRONOMY_SKILLS_IS_HEIGHT = "target_astronomy_skills_is_height"
    """ 交互对象天文学水平高 """
    TARGET_ASTRONOMY_SKILLS_IS_LOW = "target_astronomy_skills_is_low"
    """ 交互对象天文学水平低 """
    TARGET_PHYSICS_SKILLS_IS_HEIGHT = "target_physics_skills_is_height"
    """ 交互对象物理学水平高 """
    TARGET_PHYSICS_SKILLS_IS_LOW = "target_physics_skills_is_low"
    """ 交互对象物理学水平低 """
    TARGET_GEOGRAPHY_SKILLS_IS_HEIGHT = "target_geography_skills_is_height"
    """ 交互对象地理学水平高 """
    TARGET_GEOGRAPHY_SKILLS_IS_LOW = "target_geography_skills_is_low"
    """ 交互对象地理学水平低 """
    TARGET_GEOLOGY_SKILLS_IS_HEIGHT = "target_geology_skills_is_height"
    """ 交互对象地质学水平高 """
    TARGET_GEOLOGY_SKILLS_IS_LOW = "target_geology_skills_is_low"
    """ 交互对象地质学水平低 """
    TARGET_ECOLOGY_SKILLS_IS_HEIGHT = "target_ecology_skills_is_height"
    """ 交互对象生态学水平高 """
    TARGET_ECOLOGY_SKILLS_IS_LOW = "target_ecology_skills_is_low"
    """ 交互对象生态学水平低 """
    TARGET_ZOOLOGY_SKILLS_IS_HEIGHT = "target_zoology_skills_is_height"
    """ 交互对象动物学水平高 """
    TARGET_ZOOLOGY_SKILLS_IS_LOW = "target_zoology_skills_is_low"
    """ 交互对象动物学水平低 """
    TARGET_BOTANY_SKILLS_IS_HEIGHT = "target_botany_skills_is_height"
    """ 交互对象植物学水平高 """
    TARGET_BOTANY_SKILLS_IS_LOW = "target_botany_skills_is_low"
    """ 交互对象植物学水平低 """
    TARGET_ENTOMOLOGY_SKILLS_IS_HEIGHT = "target_entomology_skills_is_height"
    """ 交互对象昆虫学水平高 """
    TARGET_ENTOMOLOGY_SKILLS_IS_LOW = "target_entomology_skills_is_low"
    """ 交互对象昆虫学水平低 """
    TARGET_MICROBIOLOGY_SKILLS_IS_HEIGHT = "target_microbiology_skills_is_height"
    """ 交互对象微生物学水平高 """
    TARGET_MICROBIOLOGY_SKILLS_IS_LOW = "target_microbiology_skills_is_low"
    """ 交互对象微生物学水平低 """
    TARGET_VIROLOGY_SKILLS_IS_HEIGHT = "target_virology_skills_is_height"
    """ 交互对象病毒学水平高 """
    TARGET_VIROLOGY_SKILLS_IS_LOW = "target_virology_skills_is_low"
    """ 交互对象病毒学水平低 """
    TARGET_BECTERIOLOGY_SKILLS_IS_HEIGHT = "target_becteriology_skills_is_height"
    """ 交互对象细菌学水平高 """
    TARGET_BECTERIOLOGY_SKILLS_IS_LOW = "target_becteriology_skills_is_low"
    """ 交互对象细菌学水平低 """
    TARGET_MYCOLOGY_SKILLS_IS_HEIGHT = "target_mycology_skills_is_height"
    """ 交互对象真菌学水平高 """
    TARGET_MYCOLOGY_SKILLS_IS_LOW = "target_mycology_skills_is_low"
    """ 交互对象真菌学水平低 """
    TARGET_PHARMACY_SKILLS_IS_HEIGHT = "target_pharmacy_skills_is_height"
    """ 交互对象药学水平高 """
    TARGET_PHARMACY_SKILLS_IS_LOW = "target_pharmacy_skills_is_low"
    """ 交互对象药学水平低 """
    TARGET_METEOROLOGY_SKILLS_IS_HEIGHT = "target_meteorology_skills_is_height"
    """ 交互对象气象学水平高 """
    TARGET_METEOROLOGY_SKILLS_IS_LOW = "target_meteorology_skills_is_low"
    """ 交互对象气象学水平低 """
    TARGET_LAW_SCIENCE_SKILLS_IS_HEIGHT = "target_law_science_skills_is_height"
    """ 交互对象法学水平高 """
    TARGET_LAW_SCIENCE_SKILLS_IS_LOW = "target_law_science_skills_is_low"
    """ 交互对象法学水平低 """
    TARGET_LINGUISTICS_SKILLS_IS_HEIGHT = "target_linguistics_skills_is_height"
    """ 交互对象语言学水平高 """
    TARGET_LINGUISTICS_SKILLS_IS_LOW = "target_linguistics_skills_is_low"
    """ 交互对象语言学水平低 """

    """
    =========================
    交互对象神秘学技能类前提
    =========================
    """
    TARGET_APOTHECARY_SKILLS_IS_HEIGHT = "target_apothecary_skills_is_height"
    """ 交互对象炼金学水平高 """
    TARGET_APOTHECARY_SKILLS_IS_LOW = "target_apothecary_skills_is_low"
    """ 交互对象炼金学水平低 """
    TARGET_PARAPSYCHOLOGIES_SKILLS_IS_HEIGHT = "target_parapsychologies_skills_is_height"
    """ 交互对象通灵学水平高 """
    TARGET_PARAPSYCHOLOGIES_SKILLS_IS_LOW = "target_parapsychologies_skills_is_low"
    """ 交互对象通灵学水平低 """
    TARGET_NUMEROLOGY_SKILLS_IS_HEIGHT = "target_numerology_skills_is_height"
    """ 交互对象灵数学水平高 """
    TARGET_NUMEROLOGY_SKILLS_IS_LOW = "target_numerology_skills_is_low"
    """ 交互对象灵数学水平低 """
    TARGET_PRACTISE_DIVINATION_SKILLS_IS_HEIGHT = "target_practise_divination_skills_is_height"
    """ 交互对象占卜学水平高 """
    TARGET_PRACTISE_DIVINATION_SKILLS_IS_LOW = "target_practise_divination_skills_is_low"
    """ 交互对象占卜学水平低 """
    TARGET_PROPHECY_SKILLS_IS_HEIGHT = "target_prophecy_skills_is_height"
    """ 交互对象预言学水平高 """
    TARGET_PROPHECY_SKILLS_IS_LOW = "target_prophecy_skills_is_low"
    """ 交互对象预言学水平低 """
    TARGET_ASTROLOGY_SKILLS_IS_HEIGHT = "target_astrology_skills_is_height"
    """ 交互对象占星学水平高 """
    TARGET_ASTROLOGY_SKILLS_IS_LOW = "target_astrology_skills_is_low"
    """ 交互对象占星学水平低 """
    TARGET_DEMONOLOGY_SKILLS_IS_HEIGHT = "target_demonology_skills_is_height"
    """ 交互对象恶魔学水平高 """
    TARGET_DEMONOLOGY_SKILLS_IS_LOW = "target_demonology_skills_is_low"
    """ 交互对象恶魔学水平低 """
    TARGET_RITUAL_SKILLS_IS_HEIGHT = "target_ritual_skills_is_height"
    """ 交互对象仪式学水平高 """
    TARGET_RITUAL_SKILLS_IS_LOW = "target_ritual_skills_is_low"
    """ 交互对象仪式学水平低 """

    """
    =========================
    交互对象语言技能类前提
    =========================
    """
    TARGET_CHINESE_SKILLS_IS_HEIGHT = "target_chinese_skills_is_height"
    """ 交互对象汉语水平高 """
    TARGET_CHINESE_SKILLS_IS_LOW = "target_chinese_skills_is_low"
    """ 交互对象汉语水平低 """
    TARGET_ENGLISH_SKILLS_IS_HEIGHT = "target_english_skills_is_height"
    """ 交互对象英语水平高 """
    TARGET_ENGLISH_SKILLS_IS_LOW = "target_english_skills_is_low"
    """ 交互对象英语水平低 """
    TARGET_FRENCH_SKILLS_IS_HEIGHT = "target_french_skills_is_height"
    """ 交互对象法语水平高 """
    TARGET_FRENCH_SKILLS_IS_LOW = "target_french_skills_is_low"
    """ 交互对象法语水平低 """
    TARGET_SPANISH_SKILLS_IS_HEIGHT = "target_spanish_skills_is_height"
    """ 交互对象西班牙语水平高 """
    TARGET_SPANISH_SKILLS_IS_LOW = "target_spanish_skills_is_low"
    """ 交互对象西班牙语水平低 """
    TARGET_ARABIC_SKILLS_IS_HEIGHT = "target_arabic_skills_is_height"
    """ 交互对象阿拉伯语水平高 """
    TARGET_ARABIC_SKILLS_IS_LOW = "target_arabic_skills_is_low"
    """ 交互对象阿拉伯语水平低 """
    TARGET_RUSSIAN_SKILLS_IS_HEIGHT = "target_russian_skills_is_height"
    """ 交互对象俄语水平高 """
    TARGET_RUSSIAN_SKILLS_IS_LOW = "target_russian_skills_is_low"
    """ 交互对象俄语水平低 """
    TARGET_JAPANESE_SKILLS_IS_HEIGHT = "target_japanese_skills_is_height"
    """ 交互对象日语水平高 """
    TARGET_JAPANESE_SKILLS_IS_LOW = "target_japanese_skills_is_low"
    """ 交互对象日语水平低 """
    TARGET_HINDI_SKILLS_IS_HEIGHT = "target_hindi_skills_is_height"
    """ 交互对象印地语水平高 """
    TARGET_HINDI_SKILLS_IS_LOW = "target_hindi_skills_is_low"
    """ 交互对象印地语水平低 """
    TARGET_OLD_LATIN_SKILLS_IS_HEIGHT = "target_old_latin_skills_is_height"
    """ 交互对象古拉丁语水平高 """
    TARGET_OLD_LATIN_SKILLS_IS_LOW = "target_old_latin_skills_is_low"
    """ 交互对象古拉丁语水平低 """
    TARGET_LATIN_SKILLS_IS_HEIGHT = "target_latin_skills_is_height"
    """ 交互对象拉丁语水平高 """
    TARGET_LATIN_SKILLS_IS_LOW = "target_latin_skills_is_low"
    """ 交互对象拉丁语水平低 """
    TARGET_ANCIENT_CHINESE_SKILLS_IS_HEIGHT = "target_ancient_chinese_skills_is_height"
    """ 交互对象古汉语水平高 """
    TARGET_ANCIENT_CHINESE_SKILLS_IS_LOW = "target_ancient_chinese_skills_is_low"
    """ 交互对象古汉语水平低 """
    TARGET_OLD_SINITIC_SKILLS_IS_HEIGHT = "target_old_sinitic_skills_is_height"
    """ 交互对象上古汉语水平高 """
    TARGET_OLD_SINITIC_SKILLS_IS_LOW = "target_old_sinitic_skills_is_low"
    """ 交互对象上古汉语水平低 """

    """
    =========================
    交互对象人文天赋类前提
    =========================
    """
    TARGET_ETHIC_INTEREST_IS_HEIGHT = "target_ethic_interest_is_height"
    """ 交互对象伦理天赋水平高 """
    TARGET_ETHIC_INTEREST_IS_LOW = "target_ethic_interest_is_low"
    """ 交互对象伦理天赋水平低 """
    TARGET_MORALITY_INTEREST_IS_HEIGHT = "target_morality_interest_is_height"
    """ 交互对象道德天赋水平高 """
    TARGET_MORALITY_INTEREST_IS_LOW = "target_morality_interest_is_low"
    """ 交互对象道德天赋水平低 """
    TARGET_LITERATURE_INTEREST_IS_HEIGHT = "target_literature_interest_is_height"
    """ 交互对象文学天赋水平高 """
    TARGET_LITERATURE_INTEREST_IS_LOW = "target_literature_interest_is_low"
    """ 交互对象文学天赋水平低 """
    TARGET_POETRY_INTEREST_IS_HEIGHT = "target_poetry_interest_is_height"
    """ 交互对象诗歌天赋水平高 """
    TARGET_POETRY_INTEREST_IS_LOW = "target_poetry_interest_is_low"
    """ 交互对象诗歌天赋水平低 """
    TARGET_HISTORY_INTEREST_IS_HEIGHT = "target_history_interest_is_height"
    """ 交互对象历史天赋水平高 """
    TARGET_HISTORY_INTEREST_IS_LOW = "target_history_interest_is_low"
    """ 交互对象历史天赋水平低 """
    TARGET_ART_INTEREST_IS_HEIGHT = "target_art_interest_is_height"
    """ 交互对象艺术天赋水平高 """
    TARGET_ART_INTEREST_IS_LOW = "target_art_interest_is_low"
    """ 交互对象艺术天赋水平低 """
    TARGET_MUSIC_THEORY_INTEREST_IS_HEIGHT = "target_music_theory_interest_is_height"
    """ 交互对象乐理天赋水平高 """
    TARGET_MUSIC_THEORY_INTEREST_IS_LOW = "target_music_theory_interest_is_low"
    """ 交互对象乐理天赋水平低 """
    TARGET_RELIGION_INTEREST_IS_HEIGHT = "target_religion_interest_is_height"
    """ 交互对象宗教天赋水平高 """
    TARGET_RELIGION_INTEREST_IS_LOW = "target_religion_interest_is_low"
    """ 交互对象宗教天赋水平低 """
    TARGET_FAITH_INTEREST_IS_HEIGHT = "target_faith_interest_is_height"
    """ 交互对象信仰天赋水平高 """
    TARGET_FAITH_INTEREST_IS_LOW = "target_faith_interest_is_low"
    """ 交互对象信仰天赋水平低 """

    """
    =========================
    交互对象技巧天赋类前提
    =========================
    """
    TARGET_SEXUAL_SKILLS_INTEREST_IS_HEIGHT = "target_sexual_skills_interest_is_height"
    """ 交互对象性爱天赋水平高 """
    TARGET_SEXUAL_SKILLS_INTEREST_IS_LOW = "target_sexual_skills_interest_is_low"
    """ 交互对象性爱天赋水平低 """
    TARGET_COMPUTER_SKILLS_INTEREST_IS_HEIGHT = "target_computer_skills_interest_is_height"
    """ 交互对象计算机天赋水平高 """
    TARGET_COMPUTER_SKILLS_INTEREST_IS_LOW = "target_computer_skills_interest_is_low"
    """ 交互对象计算机天赋水平低 """
    TARGET_PERFORMANCE_SKILLS_INTEREST_IS_HEIGHT = "target_performance_skills_interest_is_height"
    """ 交互对象表演天赋水平高 """
    TARGET_PERFORMANCE_SKILLS_INTEREST_IS_LOW = "target_perform_skills_interest_is_low"
    """ 交互对象表演天赋水平低 """
    TARGET_ELOQUENCE_SKILLS_INTEREST_IS_HEIGHT = "target_eloquence_skills_interest_is_height"
    """ 交互对象口才天赋水平高 """
    TARGET_ELOQUENCE_SKILLS_INTEREST_IS_LOW = "target_eloquence_skills_interest_is_low"
    """ 交互对象口才天赋水平低 """
    TARGET_PAINTING_SKILLS_INTEREST_IS_HEIGHT = "target_painting_skills_interest_is_height"
    """ 交互对象绘画天赋水平高 """
    TARGET_PAINTING_SKILLS_INTEREST_IS_LOW = "target_painting_skills_interest_is_low"
    """ 交互对象绘画天赋水平低 """
    TARGET_SHOOT_SKILLS_INTEREST_IS_HEIGHT = "target_shoot_skills_interest_is_height"
    """ 交互对象拍摄天赋水平高 """
    TARGET_SHOOT_SKILLS_INTEREST_IS_LOW = "target_shoot_skills_interest_is_low"
    """ 交互对象拍摄天赋水平低 """
    TARGET_SINGING_SKILLS_INTEREST_IS_HEIGHT = "target_singing_skills_interest_is_height"
    """ 交互对象演唱天赋水平高 """
    TARGET_SINGING_SKILLS_INTEREST_IS_LOW = "target_singing_skills_interest_is_low"
    """ 交互对象演唱天赋水平低 """
    TARGET_WRITE_MUSIC_SKILLS_INTEREST_IS_HEIGHT = "target_write_music_skills_interest_is_height"
    """ 交互对象作曲天赋水平高 """
    TARGET_WRITE_MUSIC_SKILLS_INTEREST_IS_LOW = "target_write_music_skills_interest_is_low"
    """ 交互对象作曲天赋水平低 """
    TARGET_COOKING_SKILLS_INTEREST_IS_HEIGHT = "target_cooking_skills_interest_is_height"
    """ 交互对象厨艺天赋水平高 """
    TARGET_COOKING_SKILLS_INTEREST_IS_LOW = "target_cooking_skills_interest_is_low"
    """ 交互对象厨艺天赋水平低 """
    TARGET_DANCE_SKILLS_INTEREST_IS_HEIGHT = "target_dance_skills_interest_is_height"
    """ 交互对象舞蹈天赋水平高 """
    TARGET_DANCE_SKILLS_INTEREST_IS_LOW = "target_dance_skills_interest_is_low"
    """ 交互对象舞蹈天赋水平低 """
    TARGET_TAILOR_SKILLS_INTEREST_IS_HEIGHT = "target_tailor_skills_interest_is_height"
    """ 交互对象裁缝天赋水平高 """
    TARGET_TAILOR_SKILLS_INTEREST_IS_LOW = "target_tailor_skills_interest_is_low"
    """ 交互对象裁缝天赋水平低 """
    TARGET_TACTICS_SKILLS_INTEREST_IS_HEIGHT = "target_tactics_skills_interest_is_height"
    """ 交互对象战术天赋水平高 """
    TARGET_TACTICS_SKILLS_INTEREST_IS_LOW = "target_tactics_skills_interest_is_low"
    """ 交互对象战术天赋水平低 """
    TARGET_SWIMMING_SKILLS_INTEREST_IS_HEIGHT = "target_swimming_skills_interest_is_height"
    """ 交互对象游泳天赋水平高 """
    TARGET_SWIMMING_SKILLS_INTEREST_IS_LOW = "target_swimming_skills_interest_is_low"
    """ 交互对象游泳天赋水平低 """
    TARGET_MANUFACTURE_SKILLS_INTEREST_IS_HEIGHT = "target_manufacture_skills_interest_is_height"
    """ 交互对象制造天赋水平高 """
    TARGET_MANUFACTURE_SKILLS_INTEREST_IS_LOW = "target_manufacture_skills_interest_is_low"
    """ 交互对象制造天赋水平低 """
    TARGET_FIRST_AID_SKILLS_INTEREST_IS_HEIGHT = "target_first_aid_skills_interest_is_height"
    """ 交互对象急救天赋水平高 """
    TARGET_FIRST_AID_SKILLS_INTEREST_IS_LOW = "target_first_aid_skills_interest_is_low"
    """ 交互对象急救天赋水平低 """
    TARGET_ANATOMY_SKILLS_INTEREST_IS_HEIGHT = "target_anatomy_skills_interest_is_height"
    """ 交互对象解剖天赋水平高 """
    TARGET_ANATOMY_SKILLS_INTEREST_IS_LOW = "target_anatomy_skills_interest_is_low"
    """ 交互对象解剖天赋水平低 """
    TARGET_PLAY_MUSIC_SKILLS_INTEREST_IS_HEIGHT = "target_play_music_skills_interest_is_height"
    """ 交互对象演奏天赋水平高 """
    TARGET_PLAY_MUSIC_SKILLS_INTEREST_IS_LOW = "target_play_music_skills_interest_is_low"
    """ 交互对象演奏天赋水平低 """
    TARGET_PROGRAMMING_SKILLS_INTEREST_IS_HEIGHT = "target_programming_skills_interest_is_height"
    """ 交互对象编程天赋水平高 """
    TARGET_PROGRAMMING_SKILLS_INTEREST_IS_LOW = "target_programming_skills_interest_is_low"
    """ 交互对象编程天赋水平低 """
    TARGET_HACKER_SKILLS_INTEREST_IS_HEIGHT = "target_hacker_skills_interest_is_height"
    """ 交互对象黑客天赋水平高 """
    TARGET_HACKER_SKILLS_INTEREST_IS_LOW = "target_hacker_skills_interest_is_low"
    """ 交互对象黑客天赋水平低 """
    TARGET_WRITE_SKILLS_INTEREST_IS_HEIGHT = "target_write_skills_interest_is_height"
    """ 交互对象写作天赋水平高 """
    TARGET_WRITE_SKILLS_INTEREST_IS_LOW = "target_write_skills_interest_is_low"
    """ 交互对象写作天赋水平低 """
    TARGET_TRANSACTION_SKILLS_INTEREST_IS_HEIGHT = "target_transaction_skills_interest_is_height"
    """ 交互对象交易天赋水平高 """
    TARGET_TRANSACTION_SKILLS_INTEREST_IS_LOW = "target_transaction_skills_interest_is_low"
    """ 交互对象交易天赋水平低 """
    TARGET_CEREMONY_SKILLS_INTEREST_IS_HEIGHT = "target_ceremony_skills_interest_is_height"
    """ 交互对象礼仪天赋水平高 """
    TARGET_CEREMONY_SKILLS_INTEREST_IS_LOW = "target_ceremony_skills_interest_is_low"
    """ 交互对象礼仪天赋水平低 """
    TARGET_MOTION_SKILLS_INTEREST_IS_HEIGHT = "target_motion_skills_interest_is_height"
    """ 交互对象运动天赋水平高 """
    TARGET_MOTION_SKILLS_INTEREST_IS_LOW = "target_motion_skills_interest_is_low"
    """ 交互对象运动天赋水平低 """

    """
    =========================
    交互对象科学知识天赋类前提
    =========================
    """
    TARGET_MECHANICS_SKILLS_INTEREST_IS_HEIGHT = "target_mechanics_skills_interest_is_height"
    """ 交互对象机械学天赋水平高 """
    TARGET_MECHANICS_SKILLS_INTEREST_IS_LOW = "target_mechanics_skills_interest_is_low"
    """ 交互对象机械学天赋水平低 """
    TARGET_ELECTRONICS_SKILLS_INTEREST_IS_HEIGHT = "target_electronics_skills_interest_is_height"
    """ 交互对象电子学天赋水平高 """
    TARGET_ELECTRONICS_SKILLS_INTEREST_IS_LOW = "target_electronics_skills_interest_is_low"
    """ 交互对象电子学天赋水平低 """
    TARGET_COMPUTER_SCIENCE_SKILLS_INTEREST_IS_HEIGHT = "target_computer_science_skills_interest_is_height"
    """ 交互对象计算机学天赋水平高 """
    TARGET_COMPUTER_SCIENCE_SKILLS_INTEREST_IS_LOW = "target_computer_science_skills_interest_is_low"
    """ 交互对象计算机学天赋水平低 """
    TARGET_CRYPTOGRAPHY_SKILLS_INTEREST_IS_HEIGHT = "target_cryptography_skills_interest_is_height"
    """ 交互对象密码学天赋水平高 """
    TARGET_CRYPTOGRAPHY_SKILLS_INTEREST_IS_LOW = "target_cryptography_skills_interest_is_low"
    """ 交互对象密码学天赋水平低 """
    TARGET_CHEMISTRY_SKILLS_INTEREST_IS_HEIGHT = "target_chemistry_skills_interest_is_height"
    """ 交互对象化学天赋水平高 """
    TARGET_CHEMISTRY_SKILLS_INTEREST_IS_LOW = "target_chemistry_skills_interest_is_low"
    """ 交互对象化学天赋水平低 """
    TARGET_BIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_biology_skills_interest_is_height"
    """ 交互对象生物学天赋水平高 """
    TARGET_BIOLOGY_SKILLS_INTEREST_IS_LOW = "target_biology_skills_interest_is_low"
    """ 交互对象生物学天赋水平低 """
    TARGET_MATHEMATICS_SKILLS_INTEREST_IS_HEIGHT = "target_mathematics_skills_interest_is_height"
    """ 交互对象数学天赋水平高 """
    TARGET_MATHEMATICS_SKILLS_INTEREST_IS_LOW = "target_mathematics_skills_interest_is_low"
    """ 交互对象数学天赋水平低 """
    TARGET_ASTRONOMY_SKILLS_INTEREST_IS_HEIGHT = "target_astronomy_skills_interest_is_height"
    """ 交互对象天文学天赋水平高 """
    TARGET_ASTRONOMY_SKILLS_INTEREST_IS_LOW = "target_astronomy_skills_interest_is_low"
    """ 交互对象天文学天赋水平低 """
    TARGET_PHYSICS_SKILLS_INTEREST_IS_HEIGHT = "target_physics_skills_interest_is_height"
    """ 交互对象物理学天赋水平高 """
    TARGET_PHYSICS_SKILLS_INTEREST_IS_LOW = "target_physics_skills_interest_is_low"
    """ 交互对象物理学天赋水平低 """
    TARGET_GEOGRAPHY_SKILLS_INTEREST_IS_HEIGHT = "target_geography_skills_interest_is_height"
    """ 交互对象地理学天赋水平高 """
    TARGET_GEOGRAPHY_SKILLS_INTEREST_IS_LOW = "target_geography_skills_interest_is_low"
    """ 交互对象地理学天赋水平低 """
    TARGET_GEOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_geology_skills_interest_is_height"
    """ 交互对象地质学天赋水平高 """
    TARGET_GEOLOGY_SKILLS_INTEREST_IS_LOW = "target_geology_skills_interest_is_low"
    """ 交互对象地质学天赋水平低 """
    TARGET_ECOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_ecology_skills_interest_is_height"
    """ 交互对象生态学天赋水平高 """
    TARGET_ECOLOGY_SKILLS_INTEREST_IS_LOW = "target_ecology_skills_interest_is_low"
    """ 交互对象生态学天赋水平低 """
    TARGET_ZOOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_zoology_skills_interest_is_height"
    """ 交互对象动物学天赋水平高 """
    TARGET_ZOOLOGY_SKILLS_INTEREST_IS_LOW = "target_zoology_skills_interest_is_low"
    """ 交互对象动物学天赋水平低 """
    TARGET_BOTANY_SKILLS_INTEREST_IS_HEIGHT = "target_botany_skills_interest_is_height"
    """ 交互对象植物学天赋水平高 """
    TARGET_BOTANY_SKILLS_INTEREST_IS_LOW = "target_botany_skills_interest_is_low"
    """ 交互对象植物学天赋水平低 """
    TARGET_ENTOMOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_entomology_skills_interest_is_height"
    """ 交互对象昆虫学天赋水平高 """
    TARGET_ENTOMOLOGY_SKILLS_INTEREST_IS_LOW = "target_entomology_skills_interest_is_low"
    """ 交互对象昆虫学天赋水平低 """
    TARGET_MICROBIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_microbiology_skills_interest_is_height"
    """ 交互对象微生物学天赋水平高 """
    TARGET_MICROBIOLOGY_SKILLS_INTEREST_IS_LOW = "target_microbiology_skills_interest_is_low"
    """ 交互对象微生物学天赋水平低 """
    TARGET_VIROLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_virology_skills_interest_is_height"
    """ 交互对象病毒学天赋水平高 """
    TARGET_VIROLOGY_SKILLS_INTEREST_IS_LOW = "target_virology_skills_interest_is_low"
    """ 交互对象病毒学天赋水平低 """
    TARGET_BECTERIOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_becteriology_skills_interest_is_height"
    """ 交互对象细菌学天赋水平高 """
    TARGET_BECTERIOLOGY_SKILLS_INTEREST_IS_LOW = "target_becteriology_skills_interest_is_low"
    """ 交互对象细菌学天赋水平低 """
    TARGET_MYCOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_mycology_skills_interest_is_height"
    """ 交互对象真菌学天赋水平高 """
    TARGET_MYCOLOGY_SKILLS_INTEREST_IS_LOW = "target_mycology_skills_interest_is_low"
    """ 交互对象真菌学天赋水平低 """
    TARGET_PHARMACY_SKILLS_INTEREST_IS_HEIGHT = "target_pharmacy_skills_interest_is_height"
    """ 交互对象药学天赋水平高 """
    TARGET_PHARMACY_SKILLS_INTEREST_IS_LOW = "target_pharmacy_skills_interest_is_low"
    """ 交互对象药学天赋水平低 """
    TARGET_METEOROLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_meteorology_skills_interest_is_height"
    """ 交互对象气象学天赋水平高 """
    TARGET_METEOROLOGY_SKILLS_INTEREST_IS_LOW = "target_meteorology_skills_interest_is_low"
    """ 交互对象气象学天赋水平低 """
    TARGET_LAW_SCIENCE_SKILLS_INTEREST_IS_HEIGHT = "target_law_science_skills_interest_is_height"
    """ 交互对象法学天赋水平高 """
    TARGET_LAW_SCIENCE_SKILLS_INTEREST_IS_LOW = "target_law_science_skills_interest_is_low"
    """ 交互对象法学天赋水平低 """
    TARGET_LINGUISTICS_SKILLS_INTEREST_IS_HEIGHT = "target_linguistics_skills_interest_is_height"
    """ 交互对象语言学天赋水平高 """
    TARGET_LINGUISTICS_SKILLS_INTEREST_IS_LOW = "target_linguistics_skills_interest_is_low"
    """ 交互对象语言学天赋水平低 """

    """
    =========================
    交互对象神秘学天赋类前提
    =========================
    """
    TARGET_APOTHECARY_SKILLS_INTEREST_IS_HEIGHT = "target_apothecary_skills_interest_is_height"
    """ 交互对象炼金学天赋水平高 """
    TARGET_APOTHECARY_SKILLS_INTEREST_IS_LOW = "target_apothecary_skills_interest_is_low"
    """ 交互对象炼金学天赋水平低 """
    TARGET_PARAPSYCHOLOGIES_SKILLS_INTEREST_IS_HEIGHT = "target_parapsychologies_skills_interest_is_height"
    """ 交互对象通灵学天赋水平高 """
    TARGET_PARAPSYCHOLOGIES_SKILLS_INTEREST_IS_LOW = "target_parapsychologies_skills_interest_is_low"
    """ 交互对象通灵学天赋水平低 """
    TARGET_NUMEROLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_numerology_skills_interest_is_height"
    """ 交互对象灵数学天赋水平高 """
    TARGET_NUMEROLOGY_SKILLS_INTEREST_IS_LOW = "target_numerology_skills_interest_is_low"
    """ 交互对象灵数学天赋水平低 """
    TARGET_PRACTISE_DIVINATION_SKILLS_INTEREST_IS_HEIGHT = "target_practise_divination_skills_interest_is_height"
    """ 交互对象占卜学天赋水平高 """
    TARGET_PRACTISE_DIVINATION_SKILLS_INTEREST_IS_LOW = "target_practise_divination_skills_interest_is_low"
    """ 交互对象占卜学天赋水平低 """
    TARGET_PROPHECY_SKILLS_INTEREST_IS_HEIGHT = "target_prophecy_skills_interest_is_height"
    """ 交互对象预言学天赋水平高 """
    TARGET_PROPHECY_SKILLS_INTEREST_IS_LOW = "target_prophecy_skills_interest_is_low"
    """ 交互对象预言学天赋水平低 """
    TARGET_ASTROLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_astrology_skills_interest_is_height"
    """ 交互对象占星学天赋水平高 """
    TARGET_ASTROLOGY_SKILLS_INTEREST_IS_LOW = "target_astrology_skills_interest_is_low"
    """ 交互对象占星学天赋水平低 """
    TARGET_DEMONOLOGY_SKILLS_INTEREST_IS_HEIGHT = "target_demonology_skills_interest_is_height"
    """ 交互对象恶魔学天赋水平高 """
    TARGET_DEMONOLOGY_SKILLS_INTEREST_IS_LOW = "target_demonology_skills_interest_is_low"
    """ 交互对象恶魔学天赋水平低 """
    TARGET_RITUAL_SKILLS_INTEREST_IS_HEIGHT = "target_ritual_skills_interest_is_height"
    """ 交互对象仪式学天赋水平高 """
    TARGET_RITUAL_SKILLS_INTEREST_IS_LOW = "target_ritual_skills_interest_is_low"
    """ 交互对象仪式学天赋水平低 """

    """
    =========================
    交互对象语言天赋类前提
    =========================
    """
    TARGET_CHINESE_SKILLS_INTEREST_IS_HEIGHT = "target_chinese_skills_interest_is_height"
    """ 交互对象汉语天赋水平高 """
    TARGET_CHINESE_SKILLS_INTEREST_IS_LOW = "target_chinese_skills_interest_is_low"
    """ 交互对象汉语天赋水平低 """
    TARGET_ENGLISH_SKILLS_INTEREST_IS_HEIGHT = "target_english_skills_interest_is_height"
    """ 交互对象英语天赋水平高 """
    TARGET_ENGLISH_SKILLS_INTEREST_IS_LOW = "target_english_skills_interest_is_low"
    """ 交互对象英语天赋水平低 """
    TARGET_FRENCH_SKILLS_INTEREST_IS_HEIGHT = "target_french_skills_interest_is_height"
    """ 交互对象法语天赋水平高 """
    TARGET_FRENCH_SKILLS_INTEREST_IS_LOW = "target_french_skills_interest_is_low"
    """ 交互对象法语天赋水平低 """
    TARGET_SPANISH_SKILLS_INTEREST_IS_HEIGHT = "target_spanish_skills_interest_is_height"
    """ 交互对象西班牙语天赋水平高 """
    TARGET_SPANISH_SKILLS_INTEREST_IS_LOW = "target_spanish_skills_interest_is_low"
    """ 交互对象西班牙语天赋水平低 """
    TARGET_ARABIC_SKILLS_INTEREST_IS_HEIGHT = "target_arabic_skills_interest_is_height"
    """ 交互对象阿拉伯语天赋水平高 """
    TARGET_ARABIC_SKILLS_INTEREST_IS_LOW = "target_arabic_skills_interest_is_low"
    """ 交互对象阿拉伯语天赋水平低 """
    TARGET_RUSSIAN_SKILLS_INTEREST_IS_HEIGHT = "target_russian_skills_interest_is_height"
    """ 交互对象俄语天赋水平高 """
    TARGET_RUSSIAN_SKILLS_INTEREST_IS_LOW = "target_russian_skills_interest_is_low"
    """ 交互对象俄语天赋水平低 """
    TARGET_JAPANESE_SKILLS_INTEREST_IS_HEIGHT = "target_japanese_skills_interest_is_height"
    """ 交互对象日语天赋水平高 """
    TARGET_JAPANESE_SKILLS_INTEREST_IS_LOW = "target_japanese_skills_interest_is_low"
    """ 交互对象日语天赋水平低 """
    TARGET_HINDI_SKILLS_INTEREST_IS_HEIGHT = "target_hindi_skills_interest_is_height"
    """ 交互对象印地语天赋水平高 """
    TARGET_HINDI_SKILLS_INTEREST_IS_LOW = "target_hindi_skills_interest_is_low"
    """ 交互对象印地语天赋水平低 """
    TARGET_OLD_LATIN_SKILLS_INTEREST_IS_HEIGHT = "target_old_latin_skills_interest_is_height"
    """ 交互对象古拉丁语天赋水平高 """
    TARGET_OLD_LATIN_SKILLS_INTEREST_IS_LOW = "target_old_latin_skills_interest_is_low"
    """ 交互对象古拉丁语天赋水平低 """
    TARGET_LATIN_SKILLS_INTEREST_IS_HEIGHT = "target_latin_skills_interest_is_height"
    """ 交互对象拉丁语天赋水平高 """
    TARGET_LATIN_SKILLS_INTEREST_IS_LOW = "target_latin_skills_interest_is_low"
    """ 交互对象拉丁语天赋水平低 """
    TARGET_ANCIENT_CHINESE_SKILLS_INTEREST_IS_HEIGHT = "target_ancient_chinese_skills_interest_is_height"
    """ 交互对象古汉语天赋水平高 """
    TARGET_ANCIENT_CHINESE_SKILLS_INTEREST_IS_LOW = "target_ancient_chinese_skills_interest_is_low"
    """ 交互对象古汉语天赋水平低 """
    TARGET_OLD_SINITIC_SKILLS_INTEREST_IS_HEIGHT = "target_old_sinitic_skills_interest_is_height"
    """ 交互对象上古汉语天赋水平高 """
    TARGET_OLD_SINITIC_SKILLS_INTEREST_IS_LOW = "target_old_sinitic_skills_interest_is_low"
    """ 交互对象上古汉语天赋水平低 """

    """
    =========================
    角色临时状态类前提
    =========================
    """
    HAVE_TARGET = "have_target"
    """ 拥有交互对象 """
    EAT_SPRING_FOOD = "eat_spring_food"
    """ 食用了春药品质的食物 """
    EAT_GOOD_FOOD = "eat_good_food"
    """ 食用了良好品质的食物 """
    EAT_RUBBISH_FOOD = "eat_rubbish_food"
    """ 食用了垃圾品质的食物 """
    TARGET_IS_LIVE = "target_is_live"
    """ 交互对象未死亡 """
    NO_FOLLOW = "no_follow"
    """ 角色未处于跟随状态 """
    IS_LOSE_FIRST_KISS = "is_lose_first_kiss"
    """ 角色正在失去初吻 """
    TARGET_IS_LOSE_FIRST_KISS = "target_is_lose_first_kiss"
    """ 交互对象正在失去初吻 """
    TARGET_IS_MOVING = "target_is_moving"
    """ 交互对象正在移动 """
    TARGET_IS_PASSIVE_SEX = "target_is_passive_sex"
    """ 交互对象处于做爱受体状态 """
    TARGET_NOT_PASSIVE_SEX = "target_not_passive_sex"
    """ 交互对象未处于做爱受体状态 """

    """
    =========================
    角色心灵状态类前提
    =========================
    """
    HAPPY_IS_HEIGHT = "happy_is_height"
    """ 角色快乐情绪高涨 """
    HAPPY_IS_LOW = "happy_is_low"
    """ 角色快乐情绪低下 """
    PAIN_IS_HEIGHT = "pain_is_height"
    """ 角色痛苦情绪高涨 """
    PAIN_IS_LOW = "pain_is_low"
    """ 角色痛苦情绪低下 """
    YEARN_IS_HEIGHT = "yearn_is_height"
    """ 角色渴望情绪高涨 """
    YEARN_IS_LOW = "yearn_is_low"
    """ 角色渴望情绪低下 """
    FEAR_IS_HEIGHT = "fear_is_height"
    """ 角色恐惧情绪高涨 """
    FEAR_IS_LOW = "fear_is_low"
    """ 角色恐惧情绪低下 """
    ANTIPATHY_IS_HEIGHT = "antipathy_is_height"
    """ 角色反感情绪高涨 """
    ANTIPATHY_IS_LOW = "antipathy_is_low"
    """ 角色反感情绪低下 """
    SHAME_IS_HEIGHT = "shame_is_height"
    """ 角色羞耻情绪高涨 """
    SHAME_IS_LOW = "shame_is_low"
    """ 角色羞耻情绪低下 """
    DEPRESSED_IS_HEIGHT = "depressed_is_height"
    """ 角色抑郁情绪高涨 """
    DEPRESSED_IS_LOW = "depressed_is_low"
    """ 角色抑郁情绪低下 """
    ARROGANT_IS_HEIGHT = "arrogant_is_height"
    """ 角色傲慢情绪高涨 """
    ARROGANT_IS_LOW = "arrogant_is_low"
    """ 角色傲慢情绪低下 """
    ENVY_IS_HEIGHT = "envy_is_height"
    """ 角色嫉妒情绪高涨 """
    ENVY_IS_LOW = "envy_is_low"
    """ 角色嫉妒情绪低下 """
    RAGE_IS_HEIGHT = "rage_is_height"
    """ 角色暴怒情绪高涨 """
    RAGE_IS_LOW = "rage_is_low"
    """ 角色暴怒情绪低下 """
    LAZY_IS_HEIGHT = "lazy_is_height"
    """ 角色懒惰情绪高涨 """
    LAZY_IS_LOW = "lazy_is_low"
    """ 角色懒惰情绪低下 """
    GREEDY_IS_HEIGHT = "greedy_is_height"
    """ 角色贪婪情绪高涨 """
    GREEDY_IS_LOW = "greedy_is_low"
    """ 角色贪婪情绪低下 """
    GLUTTONY_IS_HEIGHT = "gluttony_is_height"
    """ 角色暴食情绪高涨 """
    GLUTTONY_IS_LOW = "gluttony_is_low"
    """ 角色暴食情绪低下 """
    LUST_IS_HIGHT = "lust_is_hight"
    """ 角色色欲高涨 """
    LUST_IS_LOW = "lust_is_low"
    """ 角色色欲低下 """

    """
    =========================
    角色肉体状态类前提
    =========================
    """
    HP_IS_HIGHT = "hp_is_hight"
    """ 角色身体健康 """
    HP_IS_LOW = "hp_is_low"
    """ 角色身体不健康 """
    MP_IS_HIGHT = "mp_is_hight"
    """ 角色体力充沛 """
    MP_IS_LOW = "mp_is_low"
    """ 角色体力不足 """
    IS_WARM = "is_warm"
    """ 角色感觉温暖 """
    NOT_WARM = "not_warm"
    """ 角色未感觉温暖 """
    IS_ACHE = "is_ache"
    """ 角色感觉疼痛 """
    NOT_ACHE = "not_ache"
    """ 角色未感觉疼痛 """
    IS_VERTIGO = "is_vertigo"
    """ 角色感到眩晕 """
    NOT_VERTIGO = "not_vertigo"
    """ 角色未感到眩晕 """
    IS_TIRED = "is_tired"
    """ 角色感到疲惫 """
    NOT_TIRED = "not_tired"
    """ 角色未感到疲惫 """
    IS_EXTREME_EXHAUSTION = "is_extreme_exhaustion"
    """ 角色感到极度疲惫 """
    IS_INTOXICATED = "is_intoxicated"
    """ 角色处于迷醉状态 """
    NOT_INTOXICATED = "not_intoxicated"
    """ 角色未处于迷醉状态 """
    HUNGER = "hunger"
    """ 处于饥饿状态 """
    NOT_HUNGER = "not_hunger"
    """ 角色未处于饥饿状态 """
    THIRSTY = "thirsty"
    """ 处于口渴状态 """
    NOT_THIRSTY = "not_thirsty"
    """ 角色未处于口渴状态 """

    """
    =========================
    交互对象心灵状态类前提
    =========================
    """
    TARGET_HAPPY_IS_HEIGHT = "target_happy_is_height"
    """ 交互对象快乐情绪高涨 """
    TARGET_HAPPY_IS_LOW = "target_happy_is_low"
    """ 交互对象快乐情绪低下 """
    TARGET_PAIN_IS_HEIGHT = "target_pain_is_height"
    """ 交互对象痛苦情绪高涨 """
    TARGET_PAIN_IS_LOW = "target_pain_is_low"
    """ 交互对象痛苦情绪低下 """
    TARGET_YEARN_IS_HEIGHT = "target_yearn_is_height"
    """ 交互对象渴望情绪高涨 """
    TARGET_YEARN_IS_LOW = "target_yearn_is_low"
    """ 交互对象渴望情绪低下 """
    TARGET_FEAR_IS_HEIGHT = "target_fear_is_height"
    """ 交互对象恐惧情绪高涨 """
    TARGET_FEAR_IS_LOW = "target_fear_is_low"
    """ 交互对象恐惧情绪低下 """
    TARGET_ANTIPATHY_IS_HEIGHT = "target_antipathy_is_height"
    """ 交互对象反感情绪高涨 """
    TARGET_ANTIPATHY_IS_LOW = "target_antipathy_is_low"
    """ 交互对象反感情绪低下 """
    TARGET_SHAME_IS_HEIGHT = "target_shame_is_height"
    """ 交互对象羞耻情绪高涨 """
    TARGET_SHAME_IS_LOW = "target_shame_is_low"
    """ 交互对象羞耻情绪低下 """
    TARGET_DEPRESSED_IS_HEIGHT = "target_depressed_is_height"
    """ 交互对象抑郁情绪高涨 """
    TARGET_DEPRESSED_IS_LOW = "target_depressed_is_low"
    """ 交互对象抑郁情绪低下 """
    TARGET_ARROGANT_IS_HEIGHT = "target_arrogant_height"
    """ 交互对象傲慢情绪高涨 """
    TARGET_ARROGANT_IS_LOW = "target_arrogant_is_low"
    """ 交互对象傲慢情绪低下 """
    TARGET_ENVY_IS_HEIGHT = "target_envy_is_height"
    """ 交互对象嫉妒情绪高涨 """
    TARGET_ENVY_IS_LOW = "target_envy_is_low"
    """ 交互对象嫉妒情绪低下 """
    TARGET_RAGE_IS_HEIGHT = "target_rage_is_height"
    """ 交互对象暴怒情绪高涨 """
    TARGET_RAGE_IS_LOW = "target_rage_is_low"
    """ 交互对象暴怒情绪低下 """
    TARGET_LAZY_IS_HEIGHT = "target_lazy_is_height"
    """ 交互对象懒惰情绪高涨 """
    TARGET_LAZY_IS_LOW = "target_lazy_is_low"
    """ 交互对象懒惰情绪低下 """
    TARGET_GREEDY_IS_HEIGHT = "target_greedy_is_height"
    """ 交互对象贪婪情绪高涨 """
    TARGET_GREEDY_IS_LOW = "target_greedy_is_low"
    """ 交互对象贪婪情绪低下 """
    TARGET_GLUTTONY_IS_HEIGHT = "target_gluttony_is_height"
    """ 交互对象暴食情绪高涨 """
    TARGET_GLUTTONY_IS_LOW = "target_gluttony_is_low"
    """ 交互对象暴食情绪低下 """
    TARGET_LUST_IS_HIGHT = "target_lust_is_hight"
    """ 交互对象色欲高涨 """
    TARGET_LUST_IS_LOW = "target_lust_is_low"
    """ 交互对象色欲低下 """

    """
    =========================
    交互对象肉体状态类前提
    =========================
    """
    TARGET_HP_IS_HIGHT = "target_hp_is_hight"
    """ 交互对象身体健康 """
    TARGET_HP_IS_LOW = "target_hp_is_low"
    """ 监护对象身体不健康 """
    TARGET_MP_IS_HIGHT = "target_mp_is_hight"
    """ 交互对象体力充沛 """
    TARGET_MP_IS_LOW = "target_mp_is_low"
    """ 交互对象体力不足 """
    TARGET_IS_WARM = "target_is_warm"
    """ 交互对象感觉温暖 """
    TARGET_NOT_WARM = "target_not_warm"
    """ 交互对象未感觉温暖 """
    TARGET_IS_ACHE = "target_is_ache"
    """ 交互对象感觉疼痛 """
    TARGET_NOT_ACHE = "target_not_ache"
    """ 交互对象未感觉疼痛 """
    TARGET_IS_VERTIGO = "target_is_vertigo"
    """ 交互对象感到眩晕 """
    TARGET_NOT_VERTIGO = "target_not_vertigo"
    """ 交互对象未感到眩晕 """
    TARGET_IS_TIRED = "target_is_tired"
    """ 交互对象感到疲惫 """
    TARGET_NOT_TIRED = "target_not_tired"
    """ 交互对象未感到疲惫 """
    TARGET_IS_EXTREME_EXHAUSTION = "target_is_extreme_exhaustion"
    """ 交互对象感到极度疲惫 """
    TARGET_IS_INTOXICATED = "target_is_intoxicated"
    """ 交互对象处于迷醉状态 """
    TARGET_NOT_INTOXICATED = "target_not_intoxicated"
    """ 交互对象未处于迷醉状态 """
    TARGET_HUNGER = "target_hunger"
    """ 交互对象饥饿状态 """
    TARGET_NOT_HUNGER = "target_not_hunger"
    """ 交互对象未处于饥饿状态 """
    TARGET_THIRSTY = "target_thirsty"
    """ 交互对象口渴状态 """
    TARGET_NOT_THIRSTY = "target_not_thirsty"
    """ 交互对象未处于口渴状态 """

    """
    =========================
    角色道具类前提
    =========================
    """
    HAVE_FOOD = "have_food"
    """ 拥有食物 """
    NOT_HAVE_FOOD = "not_have_food"
    """ 未拥有食物 """
    HAVE_DRAW_ITEM = "have_draw_item"
    """ 拥有绘画类道具 """
    HAVE_SHOOTING_ITEM = "have_shooting_item"
    """ 拥有射击类道具 """
    HAVE_GUITAR = "have_guitar"
    """ 拥有吉他 """
    NO_HAVE_GUITAR = "no_have_guitar"
    """ 未拥有吉他 """
    HAVE_HARMONICA = "have_harmonica"
    """ 拥有口琴 """
    HAVE_BAM_BOO_FLUTE = "have_bam_boo_flute"
    """ 拥有竹笛 """
    HAVE_BASKETBALL = "have_basketball"
    """ 拥有篮球 """
    HAVE_FOOTBALL = "have_football"
    """ 拥有足球 """
    HAVE_TABLE_TENNIS = "have_table_tennis"
    """ 拥有乒乓球 """
    HAVE_UNDERWEAR = "have_underwear"
    """ 拥有上衣 """
    HAVE_UNDERPANTS = "have_underpants"
    """ 拥有内裤 """
    HAVE_BRA = "have_bra"
    """ 拥有胸罩 """
    HAVE_PANTS = "have_pants"
    """ 拥有裤子 """
    HAVE_SKIRT = "have_skirt"
    """ 拥有短裙 """
    HAVE_SHOES = "have_shoes"
    """ 拥有鞋子 """
    HAVE_SOCKS = "have_socks"
    """ 拥有袜子 """
    HAVE_DRINKS = "have_drinks"
    """ 背包中有饮料 """
    NO_HAVE_DRINKS = "no_have_drinks"
    """ 背包中没有饮料 """
    HAVE_COAT = "have_coat"
    """ 角色拥有外套 """

    """
    =========================
    角色身材类前提
    =========================
    """
    TARGET_AGE_SIMILAR = "target_age_similar"
    """ 目标与自身年龄相差不大 """
    TARGET_AVERAGE_HEIGHT_SIMILAR = "target_average_height_similar"
    """ 目标身高与平均身高相差不大 """
    TARGET_AVERAGE_HEIGHT_LOW = "target_average_height_low"
    """ 目标身高低于平均身高 """
    TARGET_AVERGAE_STATURE_SIMILAR = "target_average_stature_similar"
    """ 目标体型与平均体型相差不大 """
    CHEST_IS_NOT_CLIFF = "chest_is_not_cliff"
    """ 胸围不是绝壁 """
    TARGET_HEIGHT_LOW = "target_height_low"
    """ 交互对象身高低于自身身高 """
    TARGET_IS_HEIGHT = "target_is_height"
    """ 目标比自己高 """
    TARGET_CHEST_IS_CLIFF = "target_chest_is_cliff"
    """ 交互对象胸围是绝壁 """
    TARGET_AVERAGE_STATURE_HEIGHT = "target_average_stature_height"
    """ 目标体型比平均体型更胖 """
    TARGET_CHEST_IS_NOT_CLIFF = "target_chest_is_not_chiff"
    """ 交互对象胸围不是绝壁 """
    IS_AVERAGE_STATURE_LOW = "is_average_stature_low"
    """ 角色体型瘦于平均体型 """

    """
    =========================
    角色穿着类前提
    =========================
    """
    TARGET_NOT_PUT_ON_UNDERWEAR = "target_not_put_on_underwear"
    """ 目标没穿上衣 """
    TARGET_NOT_PUT_ON_SKIRT = "target_not_put_on_skirt"
    """ 目标没穿短裙 """
    TARGET_IS_NAKED = "target_is_naked"
    """ 交互对象一丝不挂 """
    TARGET_NOT_PUT_ON_BRA = "target_not_put_on_bra"
    """ 交互对象没穿胸罩 """
    TARGET_NOT_PUT_ON_COAT = "target_not_put_on_coat"
    """ 交互对象没穿外套 """
    TARGET_NOT_PUT_ON_PANTS = "target_not_put_on_pants"
    """ 交互对象没穿裤子 """
    TARGET_NOT_PUT_ON_UNDERPANTS = "target_not_put_on_underpants"
    """ 交互对象没穿内裤 """
    NO_WEAR_UNDERWEAR = "no_wear_underwear"
    """ 没穿上衣 """
    NO_WEAR_UNDERPANTS = "no_wear_underpants"
    """ 没穿内裤 """
    NO_WEAR_BRA = "no_wear_bra"
    """ 没穿胸罩 """
    NO_WEAR_PANTS = "no_wear_pants"
    """ 没穿裤子 """
    NO_WEAR_SKIRT = "no_wear_skirt"
    """ 没穿短裙 """
    NO_WEAR_SHOES = "no_wear_shoes"
    """ 没穿鞋子 """
    NO_WEAR_SOCKS = "no_wear_socks"
    """ 没穿袜子 """
    PLAYER_IS_NAKED = "player_is_naked"
    """ 玩家一丝不挂 """
    IS_NAKED = "is_naked"
    """ 角色一丝不挂 """
    NOT_NAKED = "not_naked"
    """ 角色不是一丝不挂 """
    NO_WEAR_COAT = "no_wear_coat"
    """ 没穿外套 """
    WEAR_COAT = "wear_coat"
    """ 角色穿了外套 """
    WEAR_UNDERWEAR = "wear_underwear"
    """ 角色穿了上衣 """
    WEAR_UNDERPANTS = "wear_underpants"
    """ 角色穿了内裤 """
    WEAR_BRA = "wear_bra"
    """ 角色穿了胸罩 """
    WEAR_PANTS = "wear_pants"
    """ 角色穿了裤子 """
    WEAR_SKIRT = "wear_skirt"
    """ 角色穿了短裙 """
    WEAR_SHOES = "wear_shoes"
    """ 角色穿了鞋子 """
    WEAR_SOCKS = "wear_socks"
    """ 角色穿了袜子 """

    """
    =========================
    角色性经验类前提
    =========================
    """
    IS_TARGET_FIRST_KISS = "is_target_first_kiss"
    """ 是交互对象的初吻对象 """
    SEX_EXPERIENCE_IS_HIGHT = "sex_experience_is_hight"
    """ 性技熟练 """
    NO_EXPERIENCE_IN_SEX = "no_experience_in_sex"
    """ 角色没有性经验 """
    RICH_EXPERIENCE_IN_SEX = "rich_experience_in_sex"
    """ 角色性经验丰富 """
    TARGET_NO_EXPERIENCE_IN_SEX = "target_no_experience_in_sex"
    """ 交互对象没有性经验 """
    NO_RICH_EXPERIENCE_IN_SEX = "no_rich_experience_in_sex"
    """ 角色性经验不丰富 """
    TARGET_NO_FIRST_KISS = "target_no_first_kiss"
    """ 交互对象初吻还在 """
    NO_FIRST_KISS = "no_first_kiss"
    """ 初吻还在 """
    TARGET_HAVE_FIRST_KISS = "target_have_first_kiss"
    """ 交互对象初吻不在了 """
    HAVE_FIRST_KISS = "have_first_kiss"
    """ 初吻不在了 """
    TARGET_NO_FIRST_HAND_IN_HAND = "target_no_first_hand_in_hand"
    """ 交互对象没有牵过手 """
    NO_FIRST_HAND_IN_HAND = "no_first_hand_in_hand"
    """ 没有牵过手 """
    HAVE_LIKE_TARGET_NO_FIRST_KISS = "have_like_target_no_first_kiss"
    """ 有自己喜欢的人的初吻还在 """
    TARGET_CLITORIS_LEVEL_IS_HIGHT = "target_clitoris_level_is_hight"
    """ 交互对象阴蒂开发度高 """

    """
    =========================
    角色好感类前提
    =========================
    """
    TARGET_IS_ADORE = "target_is_adore"
    """ 目标是爱慕对象 """
    TARGET_IS_ADMIRE = "target_is_admire"
    """ 目标是恋慕对象 """
    PLAYER_IS_ADORE = "player_is_adore"
    """ 玩家是爱慕对象 """
    TARGET_IS_BEYOND_FRIENDSHIP = "target_is_beyond_friendship"
    """ 对目标抱有超越友谊的想法 """
    IS_BEYOND_FRIENDSHIP_TARGET = "is_beyond_friendship_target"
    """ 目标对自己抱有超越友谊的想法 """
    TARGET_ADORE = "target_adore"
    """ 被交互对象爱慕 """
    NO_BEYOND_FRIENDSHIP_TARGET = "no_beyond_friendship_target"
    """ 目标对自己没有有超越友谊的想法 """
    TARGET_ADMIRE = "target_admire"
    """ 被交互对象恋慕 """
    HAVE_LIKE_TARGET = "have_like_target"
    """ 有喜欢的人 """
    HAVE_DISLIKE_TARGET = "have_dislike_target"
    """ 有讨厌的人 """
    TARGET_NOT_STRANGER = "target_not_stranger"
    """ 交互对象不是陌生人 """
    DISLIKE_TARGET = "dislike_target"
    """ 讨厌交互对象 """
    DETEST_TARGET = "detest_target"
    """ 厌恶交互对象 """
    HATE_TARGET = "hate_target"
    """ 憎恨交互对象 """
    HATRED_TARGET = "hatred_target"
    """ 仇视交互对象 """
    DEADLY_ENEMY_TARGET = "deadly_enemy_target"
    """ 将交互对象视为死敌 """
    TARGET_DISLIKE = "target_dislike"
    """ 被交互对象讨厌 """
    TARGET_DETEST = "target_detest"
    """ 被交互对象厌恶 """
    TARGET_HATE = "target_hate"
    """ 被交互对象憎恨 """
    TARGET_HATRED = "target_hatred"
    """ 被交互对象仇视 """
    TARGET_DEADLY_ENEMY = "target_deadly_enemy"
    """ 被交互对象视为死敌 """
    TARGET_LESS_THAN_ADORE = "target_less_than_adore"
    """ 交互对象的好感小于爱慕 """

    """
    =========================
    角色行为类前提
    =========================
    """
    GET_INTO_PLAYER_SCENE = "get_into_player_scene"
    """ 进入玩家所在场景 """
    LEAVE_PLAYER_SCENE = "leave_player_scene"
    """ 离开玩家所在场景 """
    TARGET_IS_SLEEP = "target_is_sleep"
    """ 交互对象正在睡觉 """
    TARGET_IS_SING = "target_is_sing"
    """ 交互对象正在唱歌 """

    """
    =========================
    商店类类前提
    =========================
    """
    CAFETERIA_HAS_FOOD = "cafeteria_has_food"
    """ 食堂有吃的卖 """
    CAFETERIA_HAS_DRINK = "cafeteria_has_drink"
    """ 食堂有喝的卖 """

    """
    =========================
    辅助系统类前提
    =========================
    """
    IS_FOLLOW_PLAYER = "is_follow_player"
    """ 角色正在跟随玩家 """
    HAVE_FOLLOW = "have_follow"
    """ 角色拥有跟随对象 """
    NO_IN_FOLLOW_TARGET_SCENE = "no_in_follow_target_scene"
    """ 跟随的对象不在当前场景 """
    TARGET_IS_FOLLOW_PLAYER = "target_is_follow_player"
    """ 交互对象正在跟随玩家 """
    TARGET_NOT_FOLLOW_PLAYER = "target_not_follow_player"
    """ 交互对象未跟随玩家 """
    IS_COLLECTION_SYSTEM = "is_collection_system"
    """ 玩家已启用收藏模式 """
    UN_COLLECTION_SYSTEM = "un_collection_system"
    """ 玩家未启用收藏模式 """
    TARGET_IS_COLLECTION = "target_is_collection"
    """ 交互对象已被玩家收藏 """
    TARGET_IS_NOT_COLLECTION = "target_is_not_collection"
    """ 交互对象未被玩家收藏 """

    """
    =========================
    金钱类前提
    =========================
    """
    HAVE_SMALL_MONEY = "have_small_money"
    """ 拥有少量金钱 """
    HAVE_MEDIUM_MONEY = "have_medium_money"
    """ 拥有中量金钱 """
    HAVE_LARGE_MONEY = "have_large_money"
    """ 拥有大量金钱 """
    MONEY_ENOUGH_BUY_CHEAPEST_FOOD = "money_enough_buy_cheapest_food"
    """ 拥有足够买最便宜的食物的钱 """
    MONEY_ENOUGH_BUY_CHEAPEST_DRINK = "money_enough_buy_cheapest_drink"
    """ 拥有足够买最便宜的饮料的钱 """
    MONEY_ENOUGH_BUY_MOST_EXPENSIVE_FOOD = "money_enough_buy_most_expensive_food"
    """ 拥有足够买最贵的食物的钱 """
    MONEY_ENOUGH_BUY_MOST_EXPENSIVE_DRINK = "money_enough_buy_most_expensive_drink"
    """ 拥有足够买最贵的饮料的钱 """
