from Script.Design import handle_premise, constant
from Script.Core import game_type, cache_control

cache: game_type.Cache = cache_control.cache
""" 游戏缓存数据 """


@handle_premise.add_premise(constant.Premise.TARGET_IS_FUTA_OR_WOMAN)
def handle_target_is_futa_or_woman(character_id: int) -> int:
    """
    校验角色的目标对象性别是否为女性或扶她
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data = cache.character_data[character_data.target_character_id]
    if target_data.sex in {1, 2}:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.TARGET_IS_FUTA_OR_MAN)
def handle_target_is_futa_or_man(character_id: int) -> int:
    """
    校验角色的目标对象性别是否为男性或扶她
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data = cache.character_data[character_data.target_character_id]
    if target_data.sex in {0, 1}:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_MAN)
def handle_is_man(character_id: int) -> int:
    """
    校验角色是否是男性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if not character_data.sex:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_NOT_MAN)
def handle_is_not_man(character_id: int) -> int:
    """
    校验角色是否不是男性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.sex != 0:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_WOMAN)
def handle_is_woman(character_id: int) -> int:
    """
    校验角色是否是女性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.sex == 1:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_FUTA)
def handle_is_futa(character_id: int) -> int:
    """
    校验角色是否是扶她
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.sex == 2:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_ASEXUAL)
def handle_is_asexual(character_id: int) -> int:
    """
    校验角色是否是无性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.sex == 2:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_FUTA_OR_MAN)
def handle_is_futa_or_man(character_id: int) -> int:
    """
    校验角色是否是扶她或男性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.sex in {0, 2}:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.TARGET_SAME_SEX)
def handle_target_same_sex(character_id: int) -> int:
    """
    校验角色目标对像是否与自己性别相同
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data = cache.character_data[character_data.target_character_id]
    if target_data.sex == character_data.sex:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.TARGET_DIFFERENT_SEX)
def handle_target_different_sex(character_id: int) -> int:
    """
    校验角色目标对像是否与自己性别不同
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data = cache.character_data[character_data.target_character_id]
    if target_data.sex != character_data.sex:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.TARGET_IS_WOMAN)
def handle_target_is_woman(character_id: int) -> int:
    """
    校验交互对象是否是女性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data: game_type.Character = cache.character_data[character_data.target_character_id]
    if target_data.sex == 1:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.TARGET_IS_MAN)
def handle_target_is_man(character_id: int) -> int:
    """
    校验交互对象是否是男性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.target_character_id == -1:
        return 0
    target_data: game_type.Character = cache.character_data[character_data.target_character_id]
    if not target_data.sex:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_MAN_OR_WOMAN)
def handle_is_man_or_woman(character_id: int) -> int:
    """
    校验角色是否是男性或女性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.sex in {0, 1}:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_NOT_ASEXUAL)
def handle_is_not_asexual(character_id: int) -> int:
    """
    校验角色是否不是无性
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.sex != 3:
        return 1
    return 0


@handle_premise.add_premise(constant.Premise.IS_FUTA_OR_WOMAN)
def handle_is_futa_or_woman(character_id: int) -> int:
    """
    校验角色的性别是否为女性或扶她
    Keyword arguments:
    character_id -- 角色id
    Return arguments:
    int -- 权重
    """
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.sex in {1, 2}:
        return 1
    return 0
