from Script.Design import settle_behavior, constant
from Script.Core import cache_control, game_type


cache: game_type.Cache = cache_control.cache


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_CHINESE_EXPERIENCE)
def handle_add_small_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(0,0)
    experience = 0.01 * add_time * character_data.language_interest[0]
    character_data.language[0] += experience
    change_data.language.setdefault(0,0)
    change_data.language[0] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_CHINESE_EXPERIENCE)
def handle_add_medium_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(0,0)
    experience = 0.05 * add_time * character_data.language_interest[0]
    character_data.language[0] += experience
    change_data.language.setdefault(0,0)
    change_data.language[0] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_CHINESE_EXPERIENCE)
def handle_add_large_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(0,0)
    experience = 0.1 * add_time * character_data.language_interest[0]
    character_data.language[0] += experience
    change_data.language.setdefault(0,0)
    change_data.language[0] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_ENGLISH_EXPERIENCE)
def handle_add_small_english(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量英语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(1,0)
    experience = 0.01 * add_time * character_data.language_interest[1]
    character_data.language[1] += experience
    change_data.language.setdefault(1,0)
    change_data.language[1] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_ENGLISH_EXPERIENCE)
def handle_add_medium_english(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量英语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(1,0)
    experience = 0.05 * add_time * character_data.language_interest[1]
    character_data.language[1] += experience
    change_data.language.setdefault(1,0)
    change_data.language[1] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_ENGLISH_EXPERIENCE)
def handle_add_large_english(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量英语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(1,0)
    experience = 0.1 * add_time * character_data.language_interest[1]
    character_data.language[1] += experience
    change_data.language.setdefault(1,0)
    change_data.language[1] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_FRENCH_EXPERIENCE)
def handle_add_small_french(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量法语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(2,0)
    experience = 0.01 * add_time * character_data.language_interest[2]
    character_data.language[2] += experience
    change_data.language.setdefault(2,0)
    change_data.language[2] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_FRENCH_EXPERIENCE)
def handle_add_medium_french(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量法语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(2,0)
    experience = 0.05 * add_time * character_data.language_interest[2]
    character_data.language[2] += experience
    change_data.language.setdefault(2,0)
    change_data.language[2] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_FRENCH_EXPERIENCE)
def handle_add_large_french(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量法语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(2,0)
    experience = 0.1 * add_time * character_data.language_interest[2]
    character_data.language[2] += experience
    change_data.language.setdefault(2,0)
    change_data.language[2] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_SPANISH_EXPERIENCE)
def handle_add_small_spanish(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量西班牙语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(3,0)
    experience = 0.01 * add_time * character_data.language_interest[3]
    character_data.language[3] += experience
    change_data.language.setdefault(3,0)
    change_data.language[3] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_SPANISH_EXPERIENCE)
def handle_add_medium_spanish(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量西班牙语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(3,0)
    experience = 0.05 * add_time * character_data.language_interest[3]
    character_data.language[3] += experience
    change_data.language.setdefault(3,0)
    change_data.language[3] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_SPANISH_EXPERIENCE)
def handle_add_large_spanish(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量西班牙语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(3,0)
    experience = 0.1 * add_time * character_data.language_interest[3]
    character_data.language[3] += experience
    change_data.language.setdefault(3,0)
    change_data.language[3] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_ARABIC_EXPERIENCE)
def handle_add_small_arabic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量阿拉伯语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(4,0)
    experience = 0.01 * add_time * character_data.language_interest[4]
    character_data.language[4] += experience
    change_data.language.setdefault(4,0)
    change_data.language[4] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_ARABIC_EXPERIENCE)
def handle_add_medium_arabic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量阿拉伯语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(4,0)
    experience = 0.05 * add_time * character_data.language_interest[4]
    character_data.language[4] += experience
    change_data.language.setdefault(4,0)
    change_data.language[4] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_ARABIC_EXPERIENCE)
def handle_add_large_arabic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量阿拉伯语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(4,0)
    experience = 0.1 * add_time * character_data.language_interest[4]
    character_data.language[4] += experience
    change_data.language.setdefault(4,0)
    change_data.language[4] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_RUSSIAN_EXPERIENCE)
def handle_add_small_russian(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量俄语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(5,0)
    experience = 0.01 * add_time * character_data.language_interest[5]
    character_data.language[5] += experience
    change_data.language.setdefault(5,0)
    change_data.language[5] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_RUSSIAN_EXPERIENCE)
def handle_add_medium_russian(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量俄语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(5,0)
    experience = 0.05 * add_time * character_data.language_interest[5]
    character_data.language[5] += experience
    change_data.language.setdefault(5,0)
    change_data.language[5] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_RUSSIAN_EXPERIENCE)
def handle_add_large_russian(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量俄语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(5,0)
    experience = 0.1 * add_time * character_data.language_interest[5]
    character_data.language[5] += experience
    change_data.language.setdefault(5,0)
    change_data.language[5] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_JAPANESE_EXPERIENCE)
def handle_add_small_japanese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量日语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(6,0)
    experience = 0.01 * add_time * character_data.language_interest[6]
    character_data.language[6] += experience
    change_data.language.setdefault(6,0)
    change_data.language[6] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_JAPANESE_EXPERIENCE)
def handle_add_medium_japanese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量日语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(6,0)
    experience = 0.05 * add_time * character_data.language_interest[6]
    character_data.language[6] += experience
    change_data.language.setdefault(6,0)
    change_data.language[6] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_JAPANESE_EXPERIENCE)
def handle_add_large_japanese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量日语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(6,0)
    experience = 0.1 * add_time * character_data.language_interest[6]
    character_data.language[6] += experience
    change_data.language.setdefault(6,0)
    change_data.language[6] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_HINDI_EXPERIENCE)
def handle_add_small_hindi(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量印地语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(7,0)
    experience = 0.01 * add_time * character_data.language_interest[7]
    character_data.language[7] += experience
    change_data.language.setdefault(7,0)
    change_data.language[7] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_HINDI_EXPERIENCE)
def handle_add_medium_hindi(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量印地语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(7,0)
    experience = 0.05 * add_time * character_data.language_interest[7]
    character_data.language[7] += experience
    change_data.language.setdefault(7,0)
    change_data.language[7] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_HINDI_EXPERIENCE)
def handle_add_large_hindi(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量印地语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(7,0)
    experience = 0.1 * add_time * character_data.language_interest[7]
    character_data.language[7] += experience
    change_data.language.setdefault(7,0)
    change_data.language[7] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_OLD_LATIN_EXPERIENCE)
def handle_add_small_old_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量古拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(8,0)
    experience = 0.01 * add_time * character_data.language_interest[8]
    character_data.language[8] += experience
    change_data.language.setdefault(8,0)
    change_data.language[8] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_OLD_LATIN_EXPERIENCE)
def handle_add_medium_old_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量古拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(8,0)
    experience = 0.05 * add_time * character_data.language_interest[8]
    character_data.language[8] += experience
    change_data.language.setdefault(8,0)
    change_data.language[8] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_OLD_LATIN_EXPERIENCE)
def handle_add_large_old_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量古拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(8,0)
    experience = 0.1 * add_time * character_data.language_interest[8]
    character_data.language[8] += experience
    change_data.language.setdefault(8,0)
    change_data.language[8] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_LATIN_EXPERIENCE)
def handle_add_small_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(9,0)
    experience = 0.01 * add_time * character_data.language_interest[9]
    character_data.language[9] += experience
    change_data.language.setdefault(9,0)
    change_data.language[9] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_LATIN_EXPERIENCE)
def handle_add_medium_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(9,0)
    experience = 0.05 * add_time * character_data.language_interest[9]
    character_data.language[9] += experience
    change_data.language.setdefault(9,0)
    change_data.language[9] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_LATIN_EXPERIENCE)
def handle_add_large_latin(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量拉丁语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(9,0)
    experience = 0.1 * add_time * character_data.language_interest[9]
    character_data.language[9] += experience
    change_data.language.setdefault(9,0)
    change_data.language[9] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_ANCIENT_CHINESE_EXPERIENCE)
def handle_add_small_ancient_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(10,0)
    experience = 0.01 * add_time * character_data.language_interest[10]
    character_data.language[10] += experience
    change_data.language.setdefault(10,0)
    change_data.language[10] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_ANCIENT_CHINESE_EXPERIENCE)
def handle_add_medium_ancient_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(10,0)
    experience = 0.05 * add_time * character_data.language_interest[10]
    character_data.language[10] += experience
    change_data.language.setdefault(10,0)
    change_data.language[10] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_ANCIENT_CHINESE_EXPERIENCE)
def handle_add_large_ancient_chinese(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(10,0)
    experience = 0.1 * add_time * character_data.language_interest[10]
    character_data.language[10] += experience
    change_data.language.setdefault(10,0)
    change_data.language[10] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_SMALL_OLD_SINITIC_EXPERIENCE)
def handle_add_small_old_sinitic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加少量上古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(11,0)
    experience = 0.01 * add_time * character_data.language_interest[11]
    character_data.language[11] += experience
    change_data.language.setdefault(11,0)
    change_data.language[11] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_MEDIUM_OLD_SINITIC_EXPERIENCE)
def handle_add_medium_old_sinitic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加中量上古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(11,0)
    experience = 0.05 * add_time * character_data.language_interest[11]
    character_data.language[11] += experience
    change_data.language.setdefault(11,0)
    change_data.language[11] += experience


@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.ADD_LARGE_OLD_SINITIC_EXPERIENCE)
def handle_add_large_old_sinitic(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):
    """
    角色增加大量上古汉语经验
    Keyword arguments:
    character_id -- 角色id
    add_time -- 结算时间
    change_data -- 状态变更信息记录对象
    now_time -- 结算的时间戳
    """
    if not add_time:
        return
    character_data: game_type.Character = cache.character_data[character_id]
    if character_data.dead:
        return
    character_data.language.setdefault(11,0)
    experience = 0.1 * add_time * character_data.language_interest[11]
    character_data.language[11] += experience
    change_data.language.setdefault(11,0)
    change_data.language[11] += experience
