#!/usr/bin/python3
# -*- coding: UTF-8 -*-
import csv
import os

data_path = os.path.join("skills.csv")
out_path = os.path.join("out")


def build_character_skills():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] == "语言学":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    experience = 0.01 * add_time * character_data.knowledge_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.knowledge[{cid}] += experience'
            out_str += f'\n    change_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    change_data.knowledge[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    experience = 0.05 * add_time * character_data.knowledge_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.knowledge[{cid}] += experience'
            out_str += f'\n    change_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    change_data.knowledge[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    experience = 0.1 * add_time * character_data.knowledge_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.knowledge[{cid}] += experience'
            out_str += f'\n    change_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    change_data.knowledge[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_character_language():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "语言学":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.language.setdefault({cid},0)'
            out_str += f'\n    experience = 0.01 * add_time * character_data.language_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.language[{cid}] += experience'
            out_str += f'\n    change_data.language.setdefault({cid},0)'
            out_str += f'\n    change_data.language[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.language.setdefault({cid},0)'
            out_str += f'\n    experience = 0.05 * add_time * character_data.language_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.language[{cid}] += experience'
            out_str += f'\n    change_data.language.setdefault({cid},0)'
            out_str += f'\n    change_data.language[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.language.setdefault({cid},0)'
            out_str += f'\n    experience = 0.1 * add_time * character_data.language_interest[{int(row["cid"])}]'
            out_str += f'\n    character_data.language[{cid}] += experience'
            out_str += f'\n    change_data.language.setdefault({cid},0)'
            out_str += f'\n    change_data.language[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_skills():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] == "语言学":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'TARGET_ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'TARGET_ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.01 * add_time * target_data.knowledge_interest[{cid}]'
            out_str += f'\n    target_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    target_data.knowledge[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.05 * add_time * target_data.knowledge_interest[{cid}]'
            out_str += f'\n    target_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    target_data.knowledge[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.1 * add_time * target_data.knowledge_interest[{cid}]'
            out_str += f'\n    target_data.knowledge.setdefault({cid},0)'
            out_str += f'\n    target_data.knowledge[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_language():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "语言学":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'TARGET_ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'TARGET_ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.01 * add_time * target_data.language_interest[{cid}]'
            out_str += f'\n    target_data.language.setdefault({cid},0)'
            out_str += f'\n    target_data.language[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.05 * add_time * target_data.language_interest[{cid}]'
            out_str += f'\n    target_data.language.setdefault({cid},0)'
            out_str += f'\n    target_data.language[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    experience = 0.1 * add_time * target_data.language_interest[{cid}]'
            out_str += f'\n    target_data.language.setdefault({cid},0)'
            out_str += f'\n    target_data.language[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_character_sex():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "性":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time / 10'
            out_str += f'\n    character_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    change_data.sex_experience[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time / 5'
            out_str += f'\n    character_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    change_data.sex_experience[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time'
            out_str += f'\n    character_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    change_data.sex_experience[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_sex():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "性":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row['cid'])
            small_str = f'TARGET_ADD_SMALL_{skill.upper()}_EXPERIENCE'
            medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}_EXPERIENCE'
            large_str = f'TARGET_ADD_LARGE_{skill.upper()}_EXPERIENCE'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time / 10'
            out_str += f'\n    target_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid,game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.sex_experience.setdefault({cid},0)'
            out_str += f'\n    target_change.sex_experience[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time / 5'
            out_str += f'\n    target_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid,game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.sex_experience.setdefault({cid},0)'
            out_str += f'\n    target_change.sex_experience[{cid}] += experience\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}经验'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.sex_experience.setdefault({cid},0)'
            out_str += f'\n    experience = add_time'
            out_str += f'\n    target_data.sex_experience[{cid}] += experience'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid,game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.sex_experience.setdefault({cid},0)'
            out_str += f'\n    target_change.sex_experience[{cid}] += experience\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


build_target_sex()

