#!/usr/bin/python3
# -*- coding: UTF-8 -*-
import csv
import os

data_path = os.path.join("state.csv")
out_path = os.path.join("out")

def build_character_happy():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "快感":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            organ = int(row['organ'])
            add_small_str = f'ADD_SMALL_{skill.upper()}_HAPPY'
            add_medium_str = f'ADD_MEDIUM_{skill.upper()}_HAPPY'
            add_large_str = f'ADD_LARGE_{skill.upper()}_HAPPY'
            sub_small_str = f'SUB_SMALL_{skill.upper()}_HAPPY'
            sub_medium_str = f'SUB_MEDIUM_{skill.upper()}_HAPPY'
            sub_large_str = f'SUB_LARGE_{skill.upper()}_HAPPY'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_add_small_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 100'
            out_str += f'\n    character_data.status[{cid}] += character_happy'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += character_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 50'
            out_str += f'\n    character_data.status[{cid}] += character_happy'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += character_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_add_large_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 10'
            out_str += f'\n    character_data.status[{cid}] += character_happy'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += character_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_sub_small_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少少量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 100'
            out_str += f'\n    character_data.status[{cid}] -= character_happy'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= character_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_sub_medium_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少中量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 50'
            out_str += f'\n    character_data.status[{cid}] -= character_happy'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= character_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_sub_large_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少大量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    character_happy = add_time'
            out_str += f'\n    character_happy *= 1 + attr_calculation.get_experience_level_weight(character_data.sex_experience[{organ}]) + character_data.status[{cid}] / 10'
            out_str += f'\n    character_data.status[{cid}] -= character_happy'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= character_happy\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_happy():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "快感":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            organ = int(row['organ'])
            add_small_str = f'TARGET_ADD_SMALL_{skill.upper()}_HAPPY'
            add_medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}_HAPPY'
            add_large_str = f'TARGET_ADD_LARGE_{skill.upper()}_HAPPY'
            sub_small_str = f'TARGET_SUB_SMALL_{skill.upper()}_HAPPY'
            sub_medium_str = f'TARGET_SUB_MEDIUM_{skill.upper()}_HAPPY'
            sub_large_str = f'TARGET_SUB_LARGE_{skill.upper()}_HAPPY'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 100'
            out_str += f'\n    target_data.status[{cid}] += target_happy'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += target_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 50'
            out_str += f'\n    target_data.status[{cid}] += target_happy'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += target_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 10'
            out_str += f'\n    target_data.status[{cid}] += target_happy'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += target_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_target_sub_small_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少少量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 100'
            out_str += f'\n    target_data.status[{cid}] -= target_happy'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= target_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_target_sub_medium_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少中量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 50'
            out_str += f'\n    target_data.status[{cid}] -= target_happy'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= target_happy\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_target_sub_large_{skill}_happy(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少大量{skill_info}快感'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    target_happy = add_time'
            out_str += f'\n    target_happy *= 1 + attr_calculation.get_experience_level_weight(target_data.sex_experience[{organ}]) + target_data.status[{cid}] / 10'
            out_str += f'\n    target_data.status[{cid}] -= target_happy'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= target_happy\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_character_mind():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "心灵":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            add_small_str = f'ADD_SMALL_{skill.upper()}'
            add_medium_str = f'ADD_MEDIUM_{skill.upper()}'
            add_large_str = f'ADD_LARGE_{skill.upper()}'
            sub_small_str = f'SUB_SMALL_{skill.upper()}'
            sub_medium_str = f'SUB_MEDIUM_{skill.upper()}'
            sub_large_str = f'SUB_LARGE_{skill.upper()}'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_sub_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_sub_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_sub_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_mind():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "心灵":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            add_small_str = f'TARGET_ADD_SMALL_{skill.upper()}'
            add_medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}'
            add_large_str = f'TARGET_ADD_LARGE_{skill.upper()}'
            sub_small_str = f'TARGET_SUB_SMALL_{skill.upper()}'
            sub_medium_str = f'TARGET_SUB_MEDIUM_{skill.upper()}'
            sub_large_str = f'TARGET_SUB_LARGE_{skill.upper()}'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 10) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_target_sub_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_target_sub_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_target_sub_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 10) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= now_sub_value\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_character_body():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "肉体":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            add_small_str = f'ADD_SMALL_{skill.upper()}'
            add_medium_str = f'ADD_MEDIUM_{skill.upper()}'
            add_large_str = f'ADD_LARGE_{skill.upper()}'
            sub_small_str = f'SUB_SMALL_{skill.upper()}'
            sub_medium_str = f'SUB_MEDIUM_{skill.upper()}'
            sub_large_str = f'SUB_LARGE_{skill.upper()}'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色增加大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_sub_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_sub_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_sub_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    角色减少大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    character_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = character_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    character_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    character_data.status[{cid}] = max(character_data.status[{cid}],0)'
            out_str += f'\n    change_data.status.setdefault({cid},0)'
            out_str += f'\n    change_data.status[{cid}] -= now_sub_value\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)


def build_target_body():
    with open(data_path,encoding="utf-8") as now_file:
        now_read = csv.DictReader(now_file)
        out_str = ""
        for row in now_read:
            if row['skill_type'] != "肉体":
                continue
            skill:str = row["skill"]
            skill_info:str = row["skill_info"]
            cid = int(row["cid"])
            add_small_str = f'TARGET_ADD_SMALL_{skill.upper()}'
            add_medium_str = f'TARGET_ADD_MEDIUM_{skill.upper()}'
            add_large_str = f'TARGET_ADD_LARGE_{skill.upper()}'
            sub_small_str = f'TARGET_SUB_SMALL_{skill.upper()}'
            sub_medium_str = f'TARGET_SUB_MEDIUM_{skill.upper()}'
            sub_large_str = f'TARGET_SUB_LARGE_{skill.upper()}'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_small_str})'
            out_str += f'\ndef handle_target_add_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_medium_str})'
            out_str += f'\ndef handle_target_add_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{add_large_str})'
            out_str += f'\ndef handle_target_add_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象增加大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_add_value = (1 + now_value / 10) * add_time'
            out_str += f'\n    target_data.status[{cid}] += now_add_value'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_add_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_small_str})'
            out_str += f'\ndef handle_target_sub_small_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少少量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 100) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_medium_str})'
            out_str += f'\ndef handle_target_sub_medium_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少中量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 50) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] += now_sub_value\n\n'
            out_str += f'\n@settle_behavior.add_settle_behavior_effect(constant.BehaviorEffect.{sub_large_str})'
            out_str += f'\ndef handle_target_sub_large_{skill}(character_id: int, add_time: int, change_data: game_type.CharacterStatusChange, now_time: int):'
            out_str += f'\n    """'
            out_str += f'\n    交互对象减少大量{skill_info}'
            out_str += f'\n    Keyword arguments:'
            out_str += f'\n    character_id -- 角色id'
            out_str += f'\n    add_time -- 结算时间'
            out_str += f'\n    change_data -- 状态变更信息记录对象'
            out_str += f'\n    now_time -- 结算的时间戳'
            out_str += f'\n    """'
            out_str += f'\n    if not add_time:'
            out_str += f'\n        return'
            out_str += f'\n    character_data: game_type.Character = cache.character_data[character_id]'
            out_str += f'\n    if character_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data: game_type.Character = cache.character_data[character_data.target_character_id]'
            out_str += f'\n    if target_data.dead:'
            out_str += f'\n        return'
            out_str += f'\n    target_data.status.setdefault({cid},0)'
            out_str += f'\n    now_value = target_data.status[{cid}]'
            out_str += f'\n    now_sub_value = (1 + now_value / 10) * add_time'
            out_str += f'\n    target_data.status[{cid}] -= now_sub_value'
            out_str += f'\n    target_data.status[{cid}] = max(target_data.status[{cid}],0)'
            out_str += f'\n    change_data.target_change.setdefault(target_data.cid, game_type.TargetChange())'
            out_str += f'\n    target_change: game_type.TargetChange = change_data.target_change[target_data.cid]'
            out_str += f'\n    target_change.status.setdefault({cid},0)'
            out_str += f'\n    target_change.status[{cid}] -= now_sub_value\n\n'
    with open(out_path,"w",encoding="utf-8") as out_file:
        out_file.write(out_str)

build_target_body()
